<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

/**
 * The carrier for the shipment. Some carriers have a global version as well as local subsidiaries. The
 * subsidiaries are repeated over many countries and might also have an entry in the global list.
 * Choose the carrier for your country. If the carrier is not available for your country, choose the
 * global version of the carrier. If your carrier name is not in the list, set `carrier` to `OTHER` and
 * set carrier name in `carrier_name_other`. For allowed values, see Carriers.
 */
class ShipmentCarrier
{
    /**
     * DPD Russia.
     */
    public const DPD_RU = 'DPD_RU';

    /**
     * Bulgarian Posts.
     */
    public const BG_BULGARIAN_POST = 'BG_BULGARIAN_POST';

    /**
     * Koreapost (www.koreapost.go.kr).
     */
    public const KR_KOREA_POST = 'KR_KOREA_POST';

    /**
     * Courier IT.
     */
    public const ZA_COURIERIT = 'ZA_COURIERIT';

    /**
     * DPD France (formerly exapaq).
     */
    public const FR_EXAPAQ = 'FR_EXAPAQ';

    /**
     * Emirates Post.
     */
    public const ARE_EMIRATES_POST = 'ARE_EMIRATES_POST';

    /**
     * GAC.
     */
    public const GAC = 'GAC';

    /**
     * Geis CZ.
     */
    public const GEIS = 'GEIS';

    /**
     * SF Express.
     */
    public const SF_EX = 'SF_EX';

    /**
     * Pago Logistics.
     */
    public const PAGO = 'PAGO';

    /**
     * MyHermes UK.
     */
    public const MYHERMES = 'MYHERMES';

    /**
     * Diamond Eurogistics Limited.
     */
    public const DIAMOND_EUROGISTICS = 'DIAMOND_EUROGISTICS';

    /**
     * Corporate Couriers.
     */
    public const CORPORATECOURIERS_WEBHOOK = 'CORPORATECOURIERS_WEBHOOK';

    /**
     * Bond courier.
     */
    public const BOND = 'BOND';

    /**
     * Omni Parcel.
     */
    public const OMNIPARCEL = 'OMNIPARCEL';

    /**
     * Slovenska pošta.
     */
    public const SK_POSTA = 'SK_POSTA';

    /**
     * purolator.
     */
    public const PUROLATOR = 'PUROLATOR';

    /**
     * Mena 360 (Fetchr).
     */
    public const FETCHR_WEBHOOK = 'FETCHR_WEBHOOK';

    /**
     * TDG – The Delivery Group.
     */
    public const THEDELIVERYGROUP = 'THEDELIVERYGROUP';

    /**
     * Cello Square.
     */
    public const CELLO_SQUARE = 'CELLO_SQUARE';

    /**
     * TONDA GLOBAL.
     */
    public const TARRIVE = 'TARRIVE';

    /**
     * MDS Collivery Pty (Ltd).
     */
    public const COLLIVERY = 'COLLIVERY';

    /**
     * Mainfreight.
     */
    public const MAINFREIGHT = 'MAINFREIGHT';

    /**
     * First Flight Couriers.
     */
    public const IND_FIRSTFLIGHT = 'IND_FIRSTFLIGHT';

    /**
     * ACS Worldwide Express.
     */
    public const ACSWORLDWIDE = 'ACSWORLDWIDE';

    /**
     * Amstan Logistics.
     */
    public const AMSTAN = 'AMSTAN';

    /**
     * OkayParcel.
     */
    public const OKAYPARCEL = 'OKAYPARCEL';

    /**
     * Envialia Reference.
     */
    public const ENVIALIA_REFERENCE = 'ENVIALIA_REFERENCE';

    /**
     * Seur Spain.
     */
    public const SEUR_ES = 'SEUR_ES';

    /**
     * Continental.
     */
    public const CONTINENTAL = 'CONTINENTAL';

    /**
     * FDSEXPRESS.
     */
    public const FDSEXPRESS = 'FDSEXPRESS';

    /**
     * Swiship UK.
     */
    public const AMAZON_FBA_SWISHIP = 'AMAZON_FBA_SWISHIP';

    /**
     * Wyngs.
     */
    public const WYNGS = 'WYNGS';

    /**
     * DHL Active Tracing.
     */
    public const DHL_ACTIVE_TRACING = 'DHL_ACTIVE_TRACING';

    /**
     * Zyllem.
     */
    public const ZYLLEM = 'ZYLLEM';

    /**
     * Ruston.
     */
    public const RUSTON = 'RUSTON';

    /**
     * Xpost.ph.
     */
    public const XPOST = 'XPOST';

    /**
     * correos Express (www.correos.es).
     */
    public const CORREOS_ES = 'CORREOS_ES';

    /**
     * DHL France (www.dhl.com).
     */
    public const DHL_FR = 'DHL_FR';

    /**
     * Pan-Asia International.
     */
    public const PAN_ASIA = 'PAN_ASIA';

    /**
     * BRT couriers Italy (www.brt.it).
     */
    public const BRT_IT = 'BRT_IT';

    /**
     * SRE Korea (www.srekorea.co.kr).
     */
    public const SRE_KOREA = 'SRE_KOREA';

    /**
     * Spee-Dee Delivery.
     */
    public const SPEEDEE = 'SPEEDEE';

    /**
     * TNT UK Limited (www.tnt.com).
     */
    public const TNT_UK = 'TNT_UK';

    /**
     * Venipak.
     */
    public const VENIPAK = 'VENIPAK';

    /**
     * SHREE NANDAN COURIER.
     */
    public const SHREENANDANCOURIER = 'SHREENANDANCOURIER';

    /**
     * Croshot.
     */
    public const CROSHOT = 'CROSHOT';

    /**
     * NIpost (www.nipost.gov.ng).
     */
    public const NIPOST_NG = 'NIPOST_NG';

    /**
     * ePost Global.
     */
    public const EPST_GLBL = 'EPST_GLBL';

    /**
     * Newgistics.
     */
    public const NEWGISTICS = 'NEWGISTICS';

    /**
     * Post of Slovenia.
     */
    public const POST_SLOVENIA = 'POST_SLOVENIA';

    /**
     * Jersey Post.
     */
    public const JERSEY_POST = 'JERSEY_POST';

    /**
     * Bombino Express Pvt.
     */
    public const BOMBINOEXP = 'BOMBINOEXP';

    /**
     * WMG Delivery.
     */
    public const WMG = 'WMG';

    /**
     * XQ Express.
     */
    public const XQ_EXPRESS = 'XQ_EXPRESS';

    /**
     * Furdeco.
     */
    public const FURDECO = 'FURDECO';

    /**
     * LHT Express.
     */
    public const LHT_EXPRESS = 'LHT_EXPRESS';

    /**
     * South African Post Office.
     */
    public const SOUTH_AFRICAN_POST_OFFICE = 'SOUTH_AFRICAN_POST_OFFICE';

    /**
     * SPOTON Logistics Pvt Ltd.
     */
    public const SPOTON = 'SPOTON';

    /**
     * Dimerco Express Group.
     */
    public const DIMERCO = 'DIMERCO';

    /**
     * cyprus post.
     */
    public const CYPRUS_POST_CYP = 'CYPRUS_POST_CYP';

    /**
     * AB Custom Group.
     */
    public const ABCUSTOM = 'ABCUSTOM';

    /**
     * deliverE.
     */
    public const IND_DELIVREE = 'IND_DELIVREE';

    /**
     * Best Express.
     */
    public const CN_BESTEXPRESS = 'CN_BESTEXPRESS';

    /**
     * DX (SFTP).
     */
    public const DX_SFTP = 'DX_SFTP';

    /**
     * PICK UPP.
     */
    public const PICKUPP_MYS = 'PICKUPP_MYS';

    /**
     * FMX.
     */
    public const FMX = 'FMX';

    /**
     * Hellmann Worldwide Logistics.
     */
    public const HELLMANN = 'HELLMANN';

    /**
     * Ship It Asia.
     */
    public const SHIP_IT_ASIA = 'SHIP_IT_ASIA';

    /**
     * Kerry eCommerce.
     */
    public const KERRY_ECOMMERCE = 'KERRY_ECOMMERCE';

    /**
     * Frete Rapido.
     */
    public const FRETERAPIDO = 'FRETERAPIDO';

    /**
     * Pitney Bowes.
     */
    public const PITNEY_BOWES = 'PITNEY_BOWES';

    /**
     * Xpressen courier.
     */
    public const XPRESSEN_DK = 'XPRESSEN_DK';

    /**
     * Spanish Seur API.
     */
    public const SEUR_SP_API = 'SEUR_SP_API';

    /**
     * DELIVERYONTIME LOGISTICS PVT LTD.
     */
    public const DELIVERYONTIME = 'DELIVERYONTIME';

    /**
     * JINSUNG TRADING.
     */
    public const JINSUNG = 'JINSUNG';

    /**
     * Trans Kargo Internasional.
     */
    public const TRANS_KARGO = 'TRANS_KARGO';

    /**
     * Swiship DE.
     */
    public const SWISHIP_DE = 'SWISHIP_DE';

    /**
     * Ivoy courier.
     */
    public const IVOY_WEBHOOK = 'IVOY_WEBHOOK';

    /**
     * Airmee couriers.
     */
    public const AIRMEE_WEBHOOK = 'AIRMEE_WEBHOOK';

    /**
     * dhl benelux.
     */
    public const DHL_BENELUX = 'DHL_BENELUX';

    /**
     * FirstMile.
     */
    public const FIRSTMILE = 'FIRSTMILE';

    /**
     * Fastway Ireland.
     */
    public const FASTWAY_IR = 'FASTWAY_IR';

    /**
     * Hua Han Logistics.
     */
    public const HH_EXP = 'HH_EXP';

    /**
     * Mypostonline.
     */
    public const MYS_MYPOST_ONLINE = 'MYS_MYPOST_ONLINE';

    /**
     * THT Netherland.
     */
    public const TNT_NL = 'TNT_NL';

    /**
     * TIPSA courier.
     */
    public const TIPSA = 'TIPSA';

    /**
     * TAQBIN Malaysia.
     */
    public const TAQBIN_MY = 'TAQBIN_MY';

    /**
     * KGM Hub.
     */
    public const KGMHUB = 'KGMHUB';

    /**
     * Internet Express.
     */
    public const INTEXPRESS = 'INTEXPRESS';

    /**
     * Overseas Express.
     */
    public const OVERSE_EXP = 'OVERSE_EXP';

    /**
     * One click delivery services.
     */
    public const ONECLICK = 'ONECLICK';

    /**
     * Roadbull Logistics.
     */
    public const ROADRUNNER_FREIGHT = 'ROADRUNNER_FREIGHT';

    /**
     * GLS Croatia.
     */
    public const GLS_CROTIA = 'GLS_CROTIA';

    /**
     * MRW courier.
     */
    public const MRW_FTP = 'MRW_FTP';

    /**
     * Blue Express.
     */
    public const BLUEX = 'BLUEX';

    /**
     * Daylight Transport.
     */
    public const DYLT = 'DYLT';

    /**
     * DPD Ireland.
     */
    public const DPD_IR = 'DPD_IR';

    /**
     * Sin Global Express.
     */
    public const SIN_GLBL = 'SIN_GLBL';

    /**
     * Tuffnells Parcels Express- Reference.
     */
    public const TUFFNELLS_REFERENCE = 'TUFFNELLS_REFERENCE';

    /**
     * CJ Packet.
     */
    public const CJPACKET = 'CJPACKET';

    /**
     * Milkman courier.
     */
    public const MILKMAN = 'MILKMAN';

    /**
     * ASIGNA courier.
     */
    public const ASIGNA = 'ASIGNA';

    /**
     * One World Express.
     */
    public const ONEWORLDEXPRESS = 'ONEWORLDEXPRESS';

    /**
     * RoyalShipments.
     */
    public const ROYAL_MAIL = 'ROYAL_MAIL';

    /**
     * Viaxpress.
     */
    public const VIA_EXPRESS = 'VIA_EXPRESS';

    /**
     * TIG Freight.
     */
    public const TIGFREIGHT = 'TIGFREIGHT';

    /**
     * ZTO Express.
     */
    public const ZTO_EXPRESS = 'ZTO_EXPRESS';

    /**
     * 2GO Courier.
     */
    public const TWO_GO = 'TWO_GO';

    /**
     * IML courier.
     */
    public const IML = 'IML';

    /**
     * Intel-Valley Supply chain (ShenZhen) Co. Ltd.
     */
    public const INTEL_VALLEY = 'INTEL_VALLEY';

    /**
     * EFS (E-commerce Fulfillment Service).
     */
    public const EFS = 'EFS';

    /**
     * UK mail (ukmail.com).
     */
    public const UK_UK_MAIL = 'UK_UK_MAIL';

    /**
     * RAM courier.
     */
    public const RAM = 'RAM';

    /**
     * Allied Express.
     */
    public const ALLIEDEXPRESS = 'ALLIEDEXPRESS';

    /**
     * APC overnight (apc-overnight.com).
     */
    public const APC_OVERNIGHT = 'APC_OVERNIGHT';

    /**
     * Shippit.
     */
    public const SHIPPIT = 'SHIPPIT';

    /**
     * TFM Xpress.
     */
    public const TFM = 'TFM';

    /**
     * M Xpress Sdn Bhd.
     */
    public const M_XPRESS = 'M_XPRESS';

    /**
     * Haidaibao (BOX).
     */
    public const HDB_BOX = 'HDB_BOX';

    /**
     * Clevy Links.
     */
    public const CLEVY_LINKS = 'CLEVY_LINKS';

    /**
     * Beone Logistics.
     */
    public const IBEONE = 'IBEONE';

    /**
     * Fiege Netherlands.
     */
    public const FIEGE_NL = 'FIEGE_NL';

    /**
     * KWE Global.
     */
    public const KWE_GLOBAL = 'KWE_GLOBAL';

    /**
     * CTC Express.
     */
    public const CTC_EXPRESS = 'CTC_EXPRESS';

    /**
     * Amazon Shipping.
     */
    public const AMAZON = 'AMAZON';

    /**
     * Morelink.
     */
    public const MORE_LINK = 'MORE_LINK';

    /**
     * JX courier.
     */
    public const JX = 'JX';

    /**
     * Easy Mail.
     */
    public const EASY_MAIL = 'EASY_MAIL';

    /**
     * A Duie Pyle.
     */
    public const ADUIEPYLE = 'ADUIEPYLE';

    /**
     * Panther.
     */
    public const GB_PANTHER = 'GB_PANTHER';

    /**
     * Expresssale.
     */
    public const EXPRESSSALE = 'EXPRESSSALE';

    /**
     * Detrack.
     */
    public const SG_DETRACK = 'SG_DETRACK';

    /**
     * Trunkrs courier.
     */
    public const TRUNKRS_WEBHOOK = 'TRUNKRS_WEBHOOK';

    /**
     * Matdespatch.
     */
    public const MATDESPATCH = 'MATDESPATCH';

    /**
     * GLS Logistic Systems Canada Ltd./Dicom.
     */
    public const DICOM = 'DICOM';

    /**
     * MBW Courier Inc..
     */
    public const MBW = 'MBW';

    /**
     * Cambodia Post.
     */
    public const KHM_CAMBODIA_POST = 'KHM_CAMBODIA_POST';

    /**
     * Sinotrans.
     */
    public const SINOTRANS = 'SINOTRANS';

    /**
     * BRT Bartolini(Parcel ID).
     */
    public const BRT_IT_PARCELID = 'BRT_IT_PARCELID';

    /**
     * DHL Supply Chain APAC.
     */
    public const DHL_SUPPLY_CHAIN = 'DHL_SUPPLY_CHAIN';

    /**
     * DHL Poland.
     */
    public const DHL_PL = 'DHL_PL';

    /**
     * TopYou.
     */
    public const TOPYOU = 'TOPYOU';

    /**
     * PAL Express Limited.
     */
    public const PALEXPRESS = 'PALEXPRESS';

    /**
     * dhl Singapore.
     */
    public const DHL_SG = 'DHL_SG';

    /**
     * WeDo Logistics.
     */
    public const CN_WEDO = 'CN_WEDO';

    /**
     * Fulfillme.
     */
    public const FULFILLME = 'FULFILLME';

    /**
     * DPD delistrack.
     */
    public const DPD_DELISTRACK = 'DPD_DELISTRACK';

    /**
     * UPS Reference.
     */
    public const UPS_REFERENCE = 'UPS_REFERENCE';

    /**
     * Caribou.
     */
    public const CARIBOU = 'CARIBOU';

    /**
     * Locus courier.
     */
    public const LOCUS_WEBHOOK = 'LOCUS_WEBHOOK';

    /**
     * DSV courier.
     */
    public const DSV = 'DSV';

    /**
     * P2P TrakPak.
     */
    public const P2P_TRC = 'P2P_TRC';

    /**
     * Direct Parcels.
     */
    public const DIRECTPARCELS = 'DIRECTPARCELS';

    /**
     * Nova Poshta (International).
     */
    public const NOVA_POSHTA_INT = 'NOVA_POSHTA_INT';

    /**
     * FedEx® Poland Domestic.
     */
    public const FEDEX_POLAND = 'FEDEX_POLAND';

    /**
     * JCEX courier.
     */
    public const CN_JCEX = 'CN_JCEX';

    /**
     * FAR international.
     */
    public const FAR_INTERNATIONAL = 'FAR_INTERNATIONAL';

    /**
     * IDEX courier.
     */
    public const IDEXPRESS = 'IDEXPRESS';

    /**
     * GANGBAO Supplychain.
     */
    public const GANGBAO = 'GANGBAO';

    /**
     * Neway Transport.
     */
    public const NEWAY = 'NEWAY';

    /**
     * PostNL International.
     */
    public const POSTNL_INT_3_S = 'POSTNL_INT_3_S';

    /**
     * RPX Indonesia.
     */
    public const RPX_ID = 'RPX_ID';

    /**
     * Designer Transport.
     */
    public const DESIGNERTRANSPORT_WEBHOOK = 'DESIGNERTRANSPORT_WEBHOOK';

    /**
     * GLS Slovenia.
     */
    public const GLS_SLOVEN = 'GLS_SLOVEN';

    /**
     * Parcelled.in.
     */
    public const PARCELLED_IN = 'PARCELLED_IN';

    /**
     * GSI EXPRESS.
     */
    public const GSI_EXPRESS = 'GSI_EXPRESS';

    /**
     * Con-way Freight.
     */
    public const CON_WAY = 'CON_WAY';

    /**
     * Brouwer Transport en Logistiek.
     */
    public const BROUWER_TRANSPORT = 'BROUWER_TRANSPORT';

    /**
     * Captain Express International.
     */
    public const CPEX = 'CPEX';

    /**
     * Israel Post.
     */
    public const ISRAEL_POST = 'ISRAEL_POST';

    /**
     * DTDC India.
     */
    public const DTDC_IN = 'DTDC_IN';

    /**
     * PTT Post.
     */
    public const PTT_POST = 'PTT_POST';

    /**
     * Ximex Delivery Express.
     */
    public const XDE_WEBHOOK = 'XDE_WEBHOOK';

    /**
     * Tolos courier.
     */
    public const TOLOS = 'TOLOS';

    /**
     * Giao hàng nhanh.
     */
    public const GIAO_HANG = 'GIAO_HANG';

    /**
     * Geodis E-space.
     */
    public const GEODIS_ESPACE = 'GEODIS_ESPACE';

    /**
     * Magyar Post.
     */
    public const MAGYAR_HU = 'MAGYAR_HU';

    /**
     * DoorDash.
     */
    public const DOORDASH_WEBHOOK = 'DOORDASH_WEBHOOK';

    /**
     * Tiki shipment.
     */
    public const TIKI_ID = 'TIKI_ID';

    /**
     * CJ Logistics International(Hong Kong).
     */
    public const CJ_HK_INTERNATIONAL = 'CJ_HK_INTERNATIONAL';

    /**
     * Star Track Express.
     */
    public const STAR_TRACK_EXPRESS = 'STAR_TRACK_EXPRESS';

    /**
     * Helthjem.
     */
    public const HELTHJEM = 'HELTHJEM';

    /**
     * SF International.
     */
    public const SFB2C = 'SFB2C';

    /**
     * Freightquote by C.H. Robinson.
     */
    public const FREIGHTQUOTE = 'FREIGHTQUOTE';

    /**
     * Landmark Global Reference.
     */
    public const LANDMARK_GLOBAL_REFERENCE = 'LANDMARK_GLOBAL_REFERENCE';

    /**
     * Parcel2Go.
     */
    public const PARCEL2GO = 'PARCEL2GO';

    /**
     * Delnext.
     */
    public const DELNEXT = 'DELNEXT';

    /**
     * Red Carpet Logistics.
     */
    public const RCL = 'RCL';

    /**
     * CGS Express.
     */
    public const CGS_EXPRESS = 'CGS_EXPRESS';

    /**
     * Hongkong Post (www.hongkongpost.hk).
     */
    public const HK_POST = 'HK_POST';

    /**
     * SAP EXPRESS.
     */
    public const SAP_EXPRESS = 'SAP_EXPRESS';

    /**
     * Parcel Post Singapore.
     */
    public const PARCELPOST_SG = 'PARCELPOST_SG';

    /**
     * HermesWorld UK.
     */
    public const HERMES = 'HERMES';

    /**
     * Safexpress.
     */
    public const IND_SAFEEXPRESS = 'IND_SAFEEXPRESS';

    /**
     * Tophatter Express.
     */
    public const TOPHATTEREXPRESS = 'TOPHATTEREXPRESS';

    /**
     * PT MGLOBAL LOGISTICS INDONESIA.
     */
    public const MGLOBAL = 'MGLOBAL';

    /**
     * Averitt Express.
     */
    public const AVERITT = 'AVERITT';

    /**
     * leader.
     */
    public const LEADER = 'LEADER';

    /**
     * 2ebox courier.
     */
    public const _2EBOX = '_2EBOX';

    /**
     * Singapore Speedpost.
     */
    public const SG_SPEEDPOST = 'SG_SPEEDPOST';

    /**
     * DB Schenker (www.dbschenker.com).
     */
    public const DBSCHENKER_SE = 'DBSCHENKER_SE';

    /**
     * Israel Post Domestic.
     */
    public const ISR_POST_DOMESTIC = 'ISR_POST_DOMESTIC';

    /**
     * Best Way Parcel.
     */
    public const BESTWAYPARCEL = 'BESTWAYPARCEL';

    /**
     * asendia_de.
     */
    public const ASENDIA_DE = 'ASENDIA_DE';

    /**
     * nightline_uk.
     */
    public const NIGHTLINE_UK = 'NIGHTLINE_UK';

    /**
     * taqbin_sg.
     */
    public const TAQBIN_SG = 'TAQBIN_SG';

    /**
     * TCK Express.
     */
    public const TCK_EXPRESS = 'TCK_EXPRESS';

    /**
     * Endeavour Delivery.
     */
    public const ENDEAVOUR_DELIVERY = 'ENDEAVOUR_DELIVERY';

    /**
     * Nanjing Woyuan.
     */
    public const NANJINGWOYUAN = 'NANJINGWOYUAN';

    /**
     * Heppner France.
     */
    public const HEPPNER_FR = 'HEPPNER_FR';

    /**
     * EMPS Express.
     */
    public const EMPS_CN = 'EMPS_CN';

    /**
     * Fonsen Logistics.
     */
    public const FONSEN = 'FONSEN';

    /**
     * Pickrr.
     */
    public const PICKRR = 'PICKRR';

    /**
     * APC Overnight Consignment.
     */
    public const APC_OVERNIGHT_CONNUM = 'APC_OVERNIGHT_CONNUM';

    /**
     * Star Track Next Flight.
     */
    public const STAR_TRACK_NEXT_FLIGHT = 'STAR_TRACK_NEXT_FLIGHT';

    /**
     * Shanghai Aqrum Chemical Logistics Co.Ltd.
     */
    public const DAJIN = 'DAJIN';

    /**
     * UPS Freight.
     */
    public const UPS_FREIGHT = 'UPS_FREIGHT';

    /**
     * Posta Plus.
     */
    public const POSTA_PLUS = 'POSTA_PLUS';

    /**
     * CEVA LOGISTICS.
     */
    public const CEVA = 'CEVA';

    /**
     * ANSERX courier.
     */
    public const ANSERX = 'ANSERX';

    /**
     * JS EXPRESS.
     */
    public const JS_EXPRESS = 'JS_EXPRESS';

    /**
     * padtf.com.
     */
    public const PADTF = 'PADTF';

    /**
     * UPS Mail Innovations.
     */
    public const UPS_MAIL_INNOVATIONS = 'UPS_MAIL_INNOVATIONS';

    /**
     * Sunyou Post.
     */
    public const SYPOST = 'SYPOST';

    /**
     * Amazon Shipping + Amazon MCF.
     */
    public const AMAZON_SHIP_MCF = 'AMAZON_SHIP_MCF';

    /**
     * Yusen Logistics.
     */
    public const YUSEN = 'YUSEN';

    /**
     * Bring.
     */
    public const BRING = 'BRING';

    /**
     * SDA Italy.
     */
    public const SDA_IT = 'SDA_IT';

    /**
     * GBA Services Ltd.
     */
    public const GBA = 'GBA';

    /**
     * Newegg Express.
     */
    public const NEWEGGEXPRESS = 'NEWEGGEXPRESS';

    /**
     * Speed Couriers.
     */
    public const SPEEDCOURIERS_GR = 'SPEEDCOURIERS_GR';

    /**
     * forrun Pvt Ltd (Arpatech Venture).
     */
    public const FORRUN = 'FORRUN';

    /**
     * Pickupp.
     */
    public const PICKUP = 'PICKUP';

    /**
     * ECMS International Logistics Co..
     */
    public const ECMS = 'ECMS';

    /**
     * Intelipost (TMS for LATAM).
     */
    public const INTELIPOST = 'INTELIPOST';

    /**
     * Flash Express.
     */
    public const FLASHEXPRESS = 'FLASHEXPRESS';

    /**
     * STO Express.
     */
    public const CN_STO = 'CN_STO';

    /**
     * SEKO Worldwide.
     */
    public const SEKO_SFTP = 'SEKO_SFTP';

    /**
     * Home Delivery Solutions Ltd.
     */
    public const HOME_DELIVERY_SOLUTIONS = 'HOME_DELIVERY_SOLUTIONS';

    /**
     * DPD Hungary.
     */
    public const DPD_HGRY = 'DPD_HGRY';

    /**
     * Kerry Express (Vietnam) Co Ltd.
     */
    public const KERRYTTC_VN = 'KERRYTTC_VN';

    /**
     * Joying Box.
     */
    public const JOYING_BOX = 'JOYING_BOX';

    /**
     * Total Express.
     */
    public const TOTAL_EXPRESS = 'TOTAL_EXPRESS';

    /**
     * ZJS International.
     */
    public const ZJS_EXPRESS = 'ZJS_EXPRESS';

    /**
     * STARKEN couriers.
     */
    public const STARKEN = 'STARKEN';

    /**
     * DemandShip.
     */
    public const DEMANDSHIP = 'DEMANDSHIP';

    /**
     * DPEX.
     */
    public const CN_DPEX = 'CN_DPEX';

    /**
     * AuPost China.
     */
    public const AUPOST_CN = 'AUPOST_CN';

    /**
     * Logisters.
     */
    public const LOGISTERS = 'LOGISTERS';

    /**
     * Global Post.
     */
    public const GOGLOBALPOST = 'GOGLOBALPOST';

    /**
     * GLS Czech Republic.
     */
    public const GLS_CZ = 'GLS_CZ';

    /**
     * Paack courier.
     */
    public const PAACK_WEBHOOK = 'PAACK_WEBHOOK';

    /**
     * Grab courier.
     */
    public const GRAB_WEBHOOK = 'GRAB_WEBHOOK';

    /**
     * Parcelpoint.
     */
    public const PARCELPOINT = 'PARCELPOINT';

    /**
     * iCumulus.
     */
    public const ICUMULUS = 'ICUMULUS';

    /**
     * DAI Post.
     */
    public const DAIGLOBALTRACK = 'DAIGLOBALTRACK';

    /**
     * i-parcel.
     */
    public const GLOBAL_IPARCEL = 'GLOBAL_IPARCEL';

    /**
     * Yurtici Kargo.
     */
    public const YURTICI_KARGO = 'YURTICI_KARGO';

    /**
     * PayPal Package.
     */
    public const CN_PAYPAL_PACKAGE = 'CN_PAYPAL_PACKAGE';

    /**
     * Parcel To Post.
     */
    public const PARCEL_2_POST = 'PARCEL_2_POST';

    /**
     * GLS Italy.
     */
    public const GLS_IT = 'GLS_IT';

    /**
     * PIL Logistics (China) Co..
     */
    public const PIL_LOGISTICS = 'PIL_LOGISTICS';

    /**
     * Heppner Internationale Spedition GmbH & Co..
     */
    public const HEPPNER = 'HEPPNER';

    /**
     * Go!Express and logistics.
     */
    public const GENERAL_OVERNIGHT = 'GENERAL_OVERNIGHT';

    /**
     * Happy 2ThePoint.
     */
    public const HAPPY2POINT = 'HAPPY2POINT';

    /**
     * Chit Chats.
     */
    public const CHITCHATS = 'CHITCHATS';

    /**
     * Smooth Couriers.
     */
    public const SMOOTH = 'SMOOTH';

    /**
     * CL E-Logistics Solutions Limited.
     */
    public const CLE_LOGISTICS = 'CLE_LOGISTICS';

    /**
     * Fiege Logistics.
     */
    public const FIEGE = 'FIEGE';

    /**
     * M&X cargo.
     */
    public const MX_CARGO = 'MX_CARGO';

    /**
     * Ziing Final Mile Inc.
     */
    public const ZIINGFINALMILE = 'ZIINGFINALMILE';

    /**
     * Dayton Freight.
     */
    public const DAYTON_FREIGHT = 'DAYTON_FREIGHT';

    /**
     * TCS courier.
     */
    public const TCS = 'TCS';

    /**
     * AEX Group.
     */
    public const AEX = 'AEX';

    /**
     * Hermes Germany.
     */
    public const HERMES_DE = 'HERMES_DE';

    /**
     * Routific.
     */
    public const ROUTIFIC_WEBHOOK = 'ROUTIFIC_WEBHOOK';

    /**
     * Globavend.
     */
    public const GLOBAVEND = 'GLOBAVEND';

    /**
     * CJ Logistics International.
     */
    public const CJ_LOGISTICS = 'CJ_LOGISTICS';

    /**
     * The Pallet Network.
     */
    public const PALLET_NETWORK = 'PALLET_NETWORK';

    /**
     * RAF Philippines.
     */
    public const RAF_PH = 'RAF_PH';

    /**
     * XDP Express.
     */
    public const UK_XDP = 'UK_XDP';

    /**
     * Paper Express.
     */
    public const PAPER_EXPRESS = 'PAPER_EXPRESS';

    /**
     * La Poste.
     */
    public const LA_POSTE_SUIVI = 'LA_POSTE_SUIVI';

    /**
     * Paquetexpress.
     */
    public const PAQUETEXPRESS = 'PAQUETEXPRESS';

    /**
     * liefery.
     */
    public const LIEFERY = 'LIEFERY';

    /**
     * Streck Transport.
     */
    public const STRECK_TRANSPORT = 'STRECK_TRANSPORT';

    /**
     * Pony express.
     */
    public const PONY_EXPRESS = 'PONY_EXPRESS';

    /**
     * Always Express.
     */
    public const ALWAYS_EXPRESS = 'ALWAYS_EXPRESS';

    /**
     * GBS-Broker.
     */
    public const GBS_BROKER = 'GBS_BROKER';

    /**
     * City-Link Express.
     */
    public const CITYLINK_MY = 'CITYLINK_MY';

    /**
     * ALLJOY SUPPLY CHAIN.
     */
    public const ALLJOY = 'ALLJOY';

    /**
     * yodel.
     */
    public const YODEL = 'YODEL';

    /**
     * Yodel Direct.
     */
    public const YODEL_DIR = 'YODEL_DIR';

    /**
     * STONE3PL.
     */
    public const STONE3PL = 'STONE3PL';

    /**
     * ParcelPal.
     */
    public const PARCELPAL_WEBHOOK = 'PARCELPAL_WEBHOOK';

    /**
     * DHL eCommerce Asia (API).
     */
    public const DHL_ECOMERCE_ASA = 'DHL_ECOMERCE_ASA';

    /**
     * J&T Express Singapore.
     */
    public const SIMPLYPOST = 'SIMPLYPOST';

    /**
     * Kua Yue Express.
     */
    public const KY_EXPRESS = 'KY_EXPRESS';

    /**
     * shenzhen 1st International Logistics(Group)Co.
     */
    public const SHENZHEN = 'SHENZHEN';

    /**
     * LaserShip.
     */
    public const US_LASERSHIP = 'US_LASERSHIP';

    /**
     * ucexpress.
     */
    public const UC_EXPRE = 'UC_EXPRE';

    /**
     * DIDADI Logistics tech.
     */
    public const DIDADI = 'DIDADI';

    /**
     * CJ Korea Express.
     */
    public const CJ_KR = 'CJ_KR';

    /**
     * DB Schenker B2B.
     */
    public const DBSCHENKER_B2B = 'DBSCHENKER_B2B';

    /**
     * MXE Express.
     */
    public const MXE = 'MXE';

    /**
     * CAE Delivers.
     */
    public const CAE_DELIVERS = 'CAE_DELIVERS';

    /**
     * PFC Express.
     */
    public const PFCEXPRESS = 'PFCEXPRESS';

    /**
     * Whistl.
     */
    public const WHISTL = 'WHISTL';

    /**
     * WePost Sdn Bhd.
     */
    public const WEPOST = 'WEPOST';

    /**
     * DHL parcel Spain(www.dhl.com).
     */
    public const DHL_PARCEL_ES = 'DHL_PARCEL_ES';

    /**
     * DD Express Courier.
     */
    public const DDEXPRESS = 'DDEXPRESS';

    /**
     * Aramex Australia (formerly Fastway AU).
     */
    public const ARAMEX_AU = 'ARAMEX_AU';

    /**
     * Bneed courier.
     */
    public const BNEED = 'BNEED';

    /**
     * Kerry Express Hong Kong.
     */
    public const HK_TGX = 'HK_TGX';

    /**
     * Latvijas Pasts.
     */
    public const LATVIJAS_PASTS = 'LATVIJAS_PASTS';

    /**
     * ViaEurope.
     */
    public const VIAEUROPE = 'VIAEUROPE';

    /**
     * Correo Uruguayo.
     */
    public const CORREO_UY = 'CORREO_UY';

    /**
     * Chronopost france (www.chronopost.fr).
     */
    public const CHRONOPOST_FR = 'CHRONOPOST_FR';

    /**
     * J-Net.
     */
    public const J_NET = 'J_NET';

    /**
     * 6ls.com.
     */
    public const _6LS = '_6LS';

    /**
     * Belpost.
     */
    public const BLR_BELPOST = 'BLR_BELPOST';

    /**
     * BirdSystem.
     */
    public const BIRDSYSTEM = 'BIRDSYSTEM';

    /**
     * DobroPost.
     */
    public const DOBROPOST = 'DOBROPOST';

    /**
     * Wahana express (www.wahana.com).
     */
    public const WAHANA_ID = 'WAHANA_ID';

    /**
     * Weaship.
     */
    public const WEASHIP = 'WEASHIP';

    /**
     * Sonic Transportation & Logistics.
     */
    public const SONICTL = 'SONICTL';

    /**
     * Shenzhen Jinghuada Logistics Co..
     */
    public const KWT = 'KWT';

    /**
     * AFL LOGISTICS.
     */
    public const AFLLOG_FTP = 'AFLLOG_FTP';

    /**
     * SkyNet Worldwide Express.
     */
    public const SKYNET_WORLDWIDE = 'SKYNET_WORLDWIDE';

    /**
     * Nova Poshta (novaposhta.ua).
     */
    public const NOVA_POSHTA = 'NOVA_POSHTA';

    /**
     * Seino.
     */
    public const SEINO = 'SEINO';

    /**
     * SZENDEX.
     */
    public const SZENDEX = 'SZENDEX';

    /**
     * Bpost international.
     */
    public const BPOST_INT = 'BPOST_INT';

    /**
     * DB Schenker Sweden.
     */
    public const DBSCHENKER_SV = 'DBSCHENKER_SV';

    /**
     * AO Deutschland.
     */
    public const AO_DEUTSCHLAND = 'AO_DEUTSCHLAND';

    /**
     * EU Fleet Solutions.
     */
    public const EU_FLEET_SOLUTIONS = 'EU_FLEET_SOLUTIONS';

    /**
     * PCF Final Mile.
     */
    public const PCFCORP = 'PCFCORP';

    /**
     * Link Bridge(BeiJing)international logistics co..
     */
    public const LINKBRIDGE = 'LINKBRIDGE';

    /**
     * PT Prima Multi Cipta.
     */
    public const PRIMAMULTICIPTA = 'PRIMAMULTICIPTA';

    /**
     * Urbanfox.
     */
    public const COUREX = 'COUREX';

    /**
     * Zajil Express Company.
     */
    public const ZAJIL_EXPRESS = 'ZAJIL_EXPRESS';

    /**
     * CollectCo.
     */
    public const COLLECTCO = 'COLLECTCO';

    /**
     * J&T EXPRESS MALAYSIA.
     */
    public const JTEXPRESS = 'JTEXPRESS';

    /**
     * FedEx® UK.
     */
    public const FEDEX_UK = 'FEDEX_UK';

    /**
     * uShip courier.
     */
    public const USHIP = 'USHIP';

    /**
     * PIXSELL LOGISTICS.
     */
    public const PIXSELL = 'PIXSELL';

    /**
     * Shiptor.
     */
    public const SHIPTOR = 'SHIPTOR';

    /**
     * CDEK courier.
     */
    public const CDEK = 'CDEK';

    /**
     * ViettelPost.
     */
    public const VNM_VIETTELPOST = 'VNM_VIETTELPOST';

    /**
     * CJ Century.
     */
    public const CJ_CENTURY = 'CJ_CENTURY';

    /**
     * GSO(GLS-USA).
     */
    public const GSO = 'GSO';

    /**
     * VIWO IoT.
     */
    public const VIWO = 'VIWO';

    /**
     * SKYBOX.
     */
    public const SKYBOX = 'SKYBOX';

    /**
     * Kerry TJ Logistics.
     */
    public const KERRYTJ = 'KERRYTJ';

    /**
     * Nhat Tin Logistics.
     */
    public const NTLOGISTICS_VN = 'NTLOGISTICS_VN';

    /**
     * lightning monkey.
     */
    public const SDH_SCM = 'SDH_SCM';

    /**
     * Zinc courier.
     */
    public const ZINC = 'ZINC';

    /**
     * DPE South Africa.
     */
    public const DPE_SOUTH_AFRC = 'DPE_SOUTH_AFRC';

    /**
     * Czech Post.
     */
    public const CESKA_CZ = 'CESKA_CZ';

    /**
     * ACS Courier.
     */
    public const ACS_GR = 'ACS_GR';

    /**
     * DealerSend.
     */
    public const DEALERSEND = 'DEALERSEND';

    /**
     * Jocom.
     */
    public const JOCOM = 'JOCOM';

    /**
     * CSE courier.
     */
    public const CSE = 'CSE';

    /**
     * TForce Final Mile.
     */
    public const TFORCE_FINALMILE = 'TFORCE_FINALMILE';

    /**
     * ShipGate.
     */
    public const SHIP_GATE = 'SHIP_GATE';

    /**
     * SHIPTER.
     */
    public const SHIPTER = 'SHIPTER';

    /**
     * National Sameday.
     */
    public const NATIONAL_SAMEDAY = 'NATIONAL_SAMEDAY';

    /**
     * YunExpress.
     */
    public const YUNEXPRESS = 'YUNEXPRESS';

    /**
     * AliExpress Standard Shipping.
     */
    public const CAINIAO = 'CAINIAO';

    /**
     * DMSMatrix.
     */
    public const DMS_MATRIX = 'DMS_MATRIX';

    /**
     * Directlog (www.directlog.com.br).
     */
    public const DIRECTLOG = 'DIRECTLOG';

    /**
     * Asendia USA.
     */
    public const ASENDIA_US = 'ASENDIA_US';

    /**
     * 3JMS Logistics.
     */
    public const _3JMSLOGISTICS = '_3JMSLOGISTICS';

    /**
     * LICCARDI EXPRESS COURIER.
     */
    public const LICCARDI_EXPRESS = 'LICCARDI_EXPRESS';

    /**
     * SkyPostal.
     */
    public const SKY_POSTAL = 'SKY_POSTAL';

    /**
     * cnwangtong.
     */
    public const CNWANGTONG = 'CNWANGTONG';

    /**
     * ostnord denmark.
     */
    public const POSTNORD_LOGISTICS_DK = 'POSTNORD_LOGISTICS_DK';

    /**
     * Logistika.
     */
    public const LOGISTIKA = 'LOGISTIKA';

    /**
     * Celeritas Transporte.
     */
    public const CELERITAS = 'CELERITAS';

    /**
     * Pressio.
     */
    public const PRESSIODE = 'PRESSIODE';

    /**
     * Shree Maruti Courier Services Pvt Ltd.
     */
    public const SHREE_MARUTI = 'SHREE_MARUTI';

    /**
     * Logistic Worldwide Express (LWE Honkong).
     */
    public const LOGISTICSWORLDWIDE_HK = 'LOGISTICSWORLDWIDE_HK';

    /**
     * eFEx (E-Commerce Fulfillment & Express).
     */
    public const EFEX = 'EFEX';

    /**
     * Lotte Global Logistics.
     */
    public const LOTTE = 'LOTTE';

    /**
     * Lone Star Overnight.
     */
    public const LONESTAR = 'LONESTAR';

    /**
     * Aprisa Express.
     */
    public const APRISAEXPRESS = 'APRISAEXPRESS';

    /**
     * BEL North Russia.
     */
    public const BEL_RS = 'BEL_RS';

    /**
     * OSM Worldwide.
     */
    public const OSM_WORLDWIDE = 'OSM_WORLDWIDE';

    /**
     * Westgate Global.
     */
    public const WESTGATE_GL = 'WESTGATE_GL';

    /**
     * Fasttrack.
     */
    public const FASTRACK = 'FASTRACK';

    /**
     * DTD Express.
     */
    public const DTD_EXPR = 'DTD_EXPR';

    /**
     * AlfaTrex.
     */
    public const ALFATREX = 'ALFATREX';

    /**
     * ProMed Delivery.
     */
    public const PROMEDDELIVERY = 'PROMEDDELIVERY';

    /**
     * Thabit Logistics.
     */
    public const THABIT_LOGISTICS = 'THABIT_LOGISTICS';

    /**
     * HCT LOGISTICS CO.LTD..
     */
    public const HCT_LOGISTICS = 'HCT_LOGISTICS';

    /**
     * Carry-Flap Co..
     */
    public const CARRY_FLAP = 'CARRY_FLAP';

    /**
     * Old Dominion Freight Line.
     */
    public const US_OLD_DOMINION = 'US_OLD_DOMINION';

    /**
     * ANICAM BOX EXPRESS.
     */
    public const ANICAM_BOX = 'ANICAM_BOX';

    /**
     * WanbExpress.
     */
    public const WANBEXPRESS = 'WANBEXPRESS';

    /**
     * An Post.
     */
    public const AN_POST = 'AN_POST';

    /**
     * DPD Local.
     */
    public const DPD_LOCAL = 'DPD_LOCAL';

    /**
     * Stallion Express.
     */
    public const STALLIONEXPRESS = 'STALLIONEXPRESS';

    /**
     * RaidereX.
     */
    public const RAIDEREX = 'RAIDEREX';

    /**
     * ShopfansRU LLC.
     */
    public const SHOPFANS = 'SHOPFANS';

    /**
     * Kyungdong Parcel.
     */
    public const KYUNGDONG_PARCEL = 'KYUNGDONG_PARCEL';

    /**
     * Champion Logistics.
     */
    public const CHAMPION_LOGISTICS = 'CHAMPION_LOGISTICS';

    /**
     * PICK UPP (Singapore).
     */
    public const PICKUPP_SGP = 'PICKUPP_SGP';

    /**
     * Morning Express.
     */
    public const MORNING_EXPRESS = 'MORNING_EXPRESS';

    /**
     * NACEX.
     */
    public const NACEX = 'NACEX';

    /**
     * SortHub courier.
     */
    public const THENILE_WEBHOOK = 'THENILE_WEBHOOK';

    /**
     * Holisol.
     */
    public const HOLISOL = 'HOLISOL';

    /**
     * LBC EXPRESS INC..
     */
    public const LBCEXPRESS_FTP = 'LBCEXPRESS_FTP';

    /**
     * KURASI.
     */
    public const KURASI = 'KURASI';

    /**
     * USF Reddaway.
     */
    public const USF_REDDAWAY = 'USF_REDDAWAY';

    /**
     * APG eCommerce Solutions.
     */
    public const APG = 'APG';

    /**
     * BoxC courier.
     */
    public const CN_BOXC = 'CN_BOXC';

    /**
     * ECOSCOOTING.
     */
    public const ECOSCOOTING = 'ECOSCOOTING';

    /**
     * Mainway.
     */
    public const MAINWAY = 'MAINWAY';

    /**
     * Paperfly Private Limited.
     */
    public const PAPERFLY = 'PAPERFLY';

    /**
     * Hound Express.
     */
    public const HOUNDEXPRESS = 'HOUNDEXPRESS';

    /**
     * Boxberry courier.
     */
    public const BOX_BERRY = 'BOX_BERRY';

    /**
     * EP-Box courier.
     */
    public const EP_BOX = 'EP_BOX';

    /**
     * Plus UK Logistics.
     */
    public const PLUS_LOG_UK = 'PLUS_LOG_UK';

    /**
     * Fulfilla.
     */
    public const FULFILLA = 'FULFILLA';

    /**
     * ASE KARGO.
     */
    public const ASE = 'ASE';

    /**
     * MailPlus.
     */
    public const MAIL_PLUS = 'MAIL_PLUS';

    /**
     * XPO logistics.
     */
    public const XPO_LOGISTICS = 'XPO_LOGISTICS';

    /**
     * wnDirect.
     */
    public const WNDIRECT = 'WNDIRECT';

    /**
     * Cloudwish Asia.
     */
    public const CLOUDWISH_ASIA = 'CLOUDWISH_ASIA';

    /**
     * Zeleris.
     */
    public const ZELERIS = 'ZELERIS';

    /**
     * Gio Express.
     */
    public const GIO_EXPRESS = 'GIO_EXPRESS';

    /**
     * OCS WORLDWIDE.
     */
    public const OCS_WORLDWIDE = 'OCS_WORLDWIDE';

    /**
     * ARK Logistics.
     */
    public const ARK_LOGISTICS = 'ARK_LOGISTICS';

    /**
     * Aquiline.
     */
    public const AQUILINE = 'AQUILINE';

    /**
     * Pilot Freight Services.
     */
    public const PILOT_FREIGHT = 'PILOT_FREIGHT';

    /**
     * Qwintry Logistics.
     */
    public const QWINTRY = 'QWINTRY';

    /**
     * Danske Fragtaend.
     */
    public const DANSKE_FRAGT = 'DANSKE_FRAGT';

    /**
     * Carriers courier.
     */
    public const CARRIERS = 'CARRIERS';

    /**
     * Rivo (Air canada).
     */
    public const AIR_CANADA_GLOBAL = 'AIR_CANADA_GLOBAL';

    /**
     * PRESIDENT TRANSNET CORP.
     */
    public const PRESIDENT_TRANS = 'PRESIDENT_TRANS';

    /**
     * STEP FORWARD FREIGHT SERVICE CO LTD.
     */
    public const STEPFORWARDFS = 'STEPFORWARDFS';

    /**
     * Skynet UK.
     */
    public const SKYNET_UK = 'SKYNET_UK';

    /**
     * PITT OHIO.
     */
    public const PITTOHIO = 'PITTOHIO';

    /**
     * Correos Express.
     */
    public const CORREOS_EXPRESS = 'CORREOS_EXPRESS';

    /**
     * RL Carriers.
     */
    public const RL_US = 'RL_US';

    /**
     * Destiny Transportation.
     */
    public const DESTINY = 'DESTINY';

    /**
     * Yodel (www.yodel.co.uk).
     */
    public const UK_YODEL = 'UK_YODEL';

    /**
     * CometTech.
     */
    public const COMET_TECH = 'COMET_TECH';

    /**
     * DHL Parcel Russia.
     */
    public const DHL_PARCEL_RU = 'DHL_PARCEL_RU';

    /**
     * TNT Reference.
     */
    public const TNT_REFR = 'TNT_REFR';

    /**
     * Shree Anjani Courier.
     */
    public const SHREE_ANJANI_COURIER = 'SHREE_ANJANI_COURIER';

    /**
     * Mikropakket Belgium.
     */
    public const MIKROPAKKET_BE = 'MIKROPAKKET_BE';

    /**
     * RETS express.
     */
    public const ETS_EXPRESS = 'ETS_EXPRESS';

    /**
     * Colis Privé.
     */
    public const COLIS_PRIVE = 'COLIS_PRIVE';

    /**
     * Yunda Express.
     */
    public const CN_YUNDA = 'CN_YUNDA';

    /**
     * AAA Cooper.
     */
    public const AAA_COOPER = 'AAA_COOPER';

    /**
     * Rocket Parcel International.
     */
    public const ROCKET_PARCEL = 'ROCKET_PARCEL';

    /**
     * 360 Lion Express.
     */
    public const _360LION = '_360LION';

    /**
     * PANDU.
     */
    public const PANDU = 'PANDU';

    /**
     * PROFESSIONAL COURIERS.
     */
    public const PROFESSIONAL_COURIERS = 'PROFESSIONAL_COURIERS';

    /**
     * FLYTEXPRESS.
     */
    public const FLYTEXPRESS = 'FLYTEXPRESS';

    /**
     * LOGISTICSWORLDWIDE MY.
     */
    public const LOGISTICSWORLDWIDE_MY = 'LOGISTICSWORLDWIDE_MY';

    /**
     * CORREOS DE ESPANA.
     */
    public const CORREOS_DE_ESPANA = 'CORREOS_DE_ESPANA';

    /**
     * IMX.
     */
    public const IMX = 'IMX';

    /**
     * FOUR PX EXPRESS.
     */
    public const FOUR_PX_EXPRESS = 'FOUR_PX_EXPRESS';

    /**
     * XPRESSBEES.
     */
    public const XPRESSBEES = 'XPRESSBEES';

    /**
     * pickupp_vnm.
     */
    public const PICKUPP_VNM = 'PICKUPP_VNM';

    /**
     * startrack_express.
     */
    public const STARTRACK_EXPRESS1 = 'STARTRACK_EXPRESS';

    /**
     * fr_colissimo.
     */
    public const FR_COLISSIMO = 'FR_COLISSIMO';

    /**
     * nacex_spain_reference.
     */
    public const NACEX_SPAIN_REFERENCE = 'NACEX_SPAIN_REFERENCE';

    /**
     * dhl_supply_chain_au.
     */
    public const DHL_SUPPLY_CHAIN_AU = 'DHL_SUPPLY_CHAIN_AU';

    /**
     * Eshipping.
     */
    public const ESHIPPING = 'ESHIPPING';

    /**
     * SHREE TIRUPATI COURIER SERVICES PVT. LTD..
     */
    public const SHREETIRUPATI = 'SHREETIRUPATI';

    /**
     * HX Express.
     */
    public const HX_EXPRESS = 'HX_EXPRESS';

    /**
     * INDOPAKET.
     */
    public const INDOPAKET = 'INDOPAKET';

    /**
     * 17 Post Service.
     */
    public const CN_17POST = 'CN_17POST';

    /**
     * K1 Express.
     */
    public const K1_EXPRESS = 'K1_EXPRESS';

    /**
     * CJ GLS.
     */
    public const CJ_GLS = 'CJ_GLS';

    /**
     * GDEX courier.
     */
    public const MYS_GDEX = 'MYS_GDEX';

    /**
     * Nationex courier.
     */
    public const NATIONEX = 'NATIONEX';

    /**
     * Anjun couriers.
     */
    public const ANJUN = 'ANJUN';

    /**
     * FarGood.
     */
    public const FARGOOD = 'FARGOOD';

    /**
     * SMG Direct.
     */
    public const SMG_EXPRESS = 'SMG_EXPRESS';

    /**
     * RZY Express.
     */
    public const RZYEXPRESS = 'RZYEXPRESS';

    /**
     * Southeastern Freight Lines.
     */
    public const SEFL = 'SEFL';

    /**
     * TNT-Click Italy.
     */
    public const TNT_CLICK_IT = 'TNT_CLICK_IT';

    /**
     * Haidaibao.
     */
    public const HDB = 'HDB';

    /**
     * Hipshipper.
     */
    public const HIPSHIPPER = 'HIPSHIPPER';

    /**
     * RPX Logistics.
     */
    public const RPXLOGISTICS = 'RPXLOGISTICS';

    /**
     * Kuehne + Nagel.
     */
    public const KUEHNE = 'KUEHNE';

    /**
     * Nexive (TNT Post Italy).
     */
    public const IT_NEXIVE = 'IT_NEXIVE';

    /**
     * PTS courier.
     */
    public const PTS = 'PTS';

    /**
     * Swiss Post FTP.
     */
    public const SWISS_POST_FTP = 'SWISS_POST_FTP';

    /**
     * Fastrak Services.
     */
    public const FASTRK_SERV = 'FASTRK_SERV';

    /**
     * 4-72 Entregando.
     */
    public const _4_72 = '_4_72';

    /**
     * YRC courier.
     */
    public const US_YRC = 'US_YRC';

    /**
     * PostNL International 3S.
     */
    public const POSTNL_INTL_3S = 'POSTNL_INTL_3S';

    /**
     * Yilian (Elian) Supply Chain.
     */
    public const ELIAN_POST = 'ELIAN_POST';

    /**
     * Cubyn.
     */
    public const CUBYN = 'CUBYN';

    /**
     * Saudi Post.
     */
    public const SAU_SAUDI_POST = 'SAU_SAUDI_POST';

    /**
     * ABX Express.
     */
    public const ABXEXPRESS_MY = 'ABXEXPRESS_MY';

    /**
     * HUAHANG EXPRESS.
     */
    public const HUAHAN_EXPRESS = 'HUAHAN_EXPRESS';

    /**
     * Eshun international Logistic.
     */
    public const ZES_EXPRESS = 'ZES_EXPRESS';

    /**
     * ZeptoExpress.
     */
    public const ZEPTO_EXPRESS = 'ZEPTO_EXPRESS';

    /**
     * Skynet World Wide Express South Africa.
     */
    public const SKYNET_ZA = 'SKYNET_ZA';

    /**
     * Zeek2Door.
     */
    public const ZEEK_2_DOOR = 'ZEEK_2_DOOR';

    /**
     * Blink.
     */
    public const BLINKLASTMILE = 'BLINKLASTMILE';

    /**
     * UkrPoshta.
     */
    public const POSTA_UKR = 'POSTA_UKR';

    /**
     * C.H. Robinson Worldwide.
     */
    public const CHROBINSON = 'CHROBINSON';

    /**
     * Post56.
     */
    public const CN_POST56 = 'CN_POST56';

    /**
     * Courant Plus.
     */
    public const COURANT_PLUS = 'COURANT_PLUS';

    /**
     * Scudex Express.
     */
    public const SCUDEX_EXPRESS = 'SCUDEX_EXPRESS';

    /**
     * ShipEntegra.
     */
    public const SHIPENTEGRA = 'SHIPENTEGRA';

    /**
     * B2C courier Europe.
     */
    public const B_TWO_C_EUROPE = 'B_TWO_C_EUROPE';

    /**
     * Cope Sensitive Freight.
     */
    public const COPE = 'COPE';

    /**
     * Gati-KWE.
     */
    public const IND_GATI = 'IND_GATI';

    /**
     * WishPost.
     */
    public const CN_WISHPOST = 'CN_WISHPOST';

    /**
     * NACEX Spain.
     */
    public const NACEX_ES = 'NACEX_ES';

    /**
     * TAQBIN Hong Kong.
     */
    public const TAQBIN_HK = 'TAQBIN_HK';

    /**
     * GlobalTranz.
     */
    public const GLOBALTRANZ = 'GLOBALTRANZ';

    /**
     * Qingdao HKD International Logistics.
     */
    public const HKD = 'HKD';

    /**
     * BJS Distribution courier.
     */
    public const BJSHOMEDELIVERY = 'BJSHOMEDELIVERY';

    /**
     * Omniva.
     */
    public const OMNIVA = 'OMNIVA';

    /**
     * Sutton Transport.
     */
    public const SUTTON = 'SUTTON';

    /**
     * Panther Reference.
     */
    public const PANTHER_REFERENCE = 'PANTHER_REFERENCE';

    /**
     * SFC Service.
     */
    public const SFCSERVICE = 'SFCSERVICE';

    /**
     * LTL COURIER.
     */
    public const LTL = 'LTL';

    /**
     * Park N Parcel.
     */
    public const PARKNPARCEL = 'PARKNPARCEL';

    /**
     * Spring GDS.
     */
    public const SPRING_GDS = 'SPRING_GDS';

    /**
     * ECexpress.
     */
    public const ECEXPRESS = 'ECEXPRESS';

    /**
     * Interparcel Australia.
     */
    public const INTERPARCEL_AU = 'INTERPARCEL_AU';

    /**
     * Agility.
     */
    public const AGILITY = 'AGILITY';

    /**
     * XL Express.
     */
    public const XL_EXPRESS = 'XL_EXPRESS';

    /**
     * Ader couriers.
     */
    public const ADERONLINE = 'ADERONLINE';

    /**
     * Direct Couriers.
     */
    public const DIRECTCOURIERS = 'DIRECTCOURIERS';

    /**
     * Planzer Group.
     */
    public const PLANZER = 'PLANZER';

    /**
     * Sending Transporte Urgente y Comunicacion.
     */
    public const SENDING = 'SENDING';

    /**
     * Ninjavan Webhook.
     */
    public const NINJAVAN_WB = 'NINJAVAN_WB';

    /**
     * Nationwide Express Courier Services Bhd (www.nationwide.com.my).
     */
    public const NATIONWIDE_MY = 'NATIONWIDE_MY';

    /**
     * Sendit.
     */
    public const SENDIT = 'SENDIT';

    /**
     * Arrow XL.
     */
    public const GB_ARROW = 'GB_ARROW';

    /**
     * GoJavas.
     */
    public const IND_GOJAVAS = 'IND_GOJAVAS';

    /**
     * Korea Post.
     */
    public const KPOST = 'KPOST';

    /**
     * DHL Freight.
     */
    public const DHL_FREIGHT = 'DHL_FREIGHT';

    /**
     * Bluecare Express Ltd.
     */
    public const BLUECARE = 'BLUECARE';

    /**
     * jindouyun courier.
     */
    public const JINDOUYUN = 'JINDOUYUN';

    /**
     * Trackon Couriers Pvt. Ltd.
     */
    public const TRACKON = 'TRACKON';

    /**
     * Tuffnells Parcels Express.
     */
    public const GB_TUFFNELLS = 'GB_TUFFNELLS';

    /**
     * TRUMPCARD LLC.
     */
    public const TRUMPCARD = 'TRUMPCARD';

    /**
     * eTotal Solution Limited.
     */
    public const ETOTAL = 'ETOTAL';

    /**
     * Zeek courier.
     */
    public const SFPLUS_WEBHOOK = 'SFPLUS_WEBHOOK';

    /**
     * SEKO Logistics.
     */
    public const SEKOLOGISTICS = 'SEKOLOGISTICS';

    /**
     * Hermes Einrichtungs Service GmbH & Co. KG.
     */
    public const HERMES_2MANN_HANDLING = 'HERMES_2MANN_HANDLING';

    /**
     * DPD Local reference.
     */
    public const DPD_LOCAL_REF = 'DPD_LOCAL_REF';

    /**
     * United Delivery Service.
     */
    public const UDS = 'UDS';

    /**
     * Specialised Freight.
     */
    public const ZA_SPECIALISED_FREIGHT = 'ZA_SPECIALISED_FREIGHT';

    /**
     * Kerry Express Thailand.
     */
    public const THA_KERRY = 'THA_KERRY';

    /**
     * SEUR International.
     */
    public const PRT_INT_SEUR = 'PRT_INT_SEUR';

    /**
     * Correios Brazil.
     */
    public const BRA_CORREIOS = 'BRA_CORREIOS';

    /**
     * New Zealand Post.
     */
    public const NZ_NZ_POST = 'NZ_NZ_POST';

    /**
     * Equick China.
     */
    public const CN_EQUICK = 'CN_EQUICK';

    /**
     * Malaysia Post EMS / Pos Laju.
     */
    public const MYS_EMS = 'MYS_EMS';

    /**
     * Norsk Global.
     */
    public const GB_NORSK = 'GB_NORSK';

    /**
     * MRW spain.
     */
    public const ESP_MRW = 'ESP_MRW';

    /**
     * Packlink.
     */
    public const ESP_PACKLINK = 'ESP_PACKLINK';

    /**
     * Kangaroo Worldwide Express.
     */
    public const KANGAROO_MY = 'KANGAROO_MY';

    /**
     * RPX Online.
     */
    public const RPX = 'RPX';

    /**
     * XDP Express Reference.
     */
    public const XDP_UK_REFERENCE = 'XDP_UK_REFERENCE';

    /**
     * ninja van (www.ninjavan.co).
     */
    public const NINJAVAN_MY = 'NINJAVAN_MY';

    /**
     * Adicional Logistics.
     */
    public const ADICIONAL = 'ADICIONAL';

    /**
     * Red Carpet Logistics.
     */
    public const ROADBULL = 'ROADBULL';

    /**
     * Yakit courier.
     */
    public const YAKIT = 'YAKIT';

    /**
     * MailAmericas.
     */
    public const MAILAMERICAS = 'MAILAMERICAS';

    /**
     * Mikropakket.
     */
    public const MIKROPAKKET = 'MIKROPAKKET';

    /**
     * Dynamic Logistics.
     */
    public const DYNALOGIC = 'DYNALOGIC';

    /**
     * DHL Spain(www.dhl.com).
     */
    public const DHL_ES = 'DHL_ES';

    /**
     * DHL Parcel NL.
     */
    public const DHL_PARCEL_NL = 'DHL_PARCEL_NL';

    /**
     * DHL Global Mail Asia (www.dhl.com).
     */
    public const DHL_GLOBAL_MAIL_ASIA = 'DHL_GLOBAL_MAIL_ASIA';

    /**
     * Dawn Wing.
     */
    public const DAWN_WING = 'DAWN_WING';

    /**
     * Geniki Taxydromiki.
     */
    public const GENIKI_GR = 'GENIKI_GR';

    /**
     * hermesworld_uk.
     */
    public const HERMESWORLD_UK = 'HERMESWORLD_UK';

    /**
     * Alphafast (www.alphafast.com).
     */
    public const ALPHAFAST = 'ALPHAFAST';

    /**
     * buylogic.
     */
    public const BUYLOGIC = 'BUYLOGIC';

    /**
     * Ekart logistics (ekartlogistics.com).
     */
    public const EKART = 'EKART';

    /**
     * mexico senda express.
     */
    public const MEX_SENDA = 'MEX_SENDA';

    /**
     * SFC.
     */
    public const SFC_LOGISTICS = 'SFC_LOGISTICS';

    /**
     * Posta Serbia.
     */
    public const POST_SERBIA = 'POST_SERBIA';

    /**
     * Delhivery India.
     */
    public const IND_DELHIVERY = 'IND_DELHIVERY';

    /**
     * DPD Germany.
     */
    public const DE_DPD_DELISTRACK = 'DE_DPD_DELISTRACK';

    /**
     * RPD2man Deliveries.
     */
    public const RPD2MAN = 'RPD2MAN';

    /**
     * SF Express (www.sf-express.com).
     */
    public const CN_SF_EXPRESS = 'CN_SF_EXPRESS';

    /**
     * Yanwen Logistics.
     */
    public const YANWEN = 'YANWEN';

    /**
     * Skynet Malaysia.
     */
    public const MYS_SKYNET = 'MYS_SKYNET';

    /**
     * correos mexico.
     */
    public const CORREOS_DE_MEXICO = 'CORREOS_DE_MEXICO';

    /**
     * CBL Logistica.
     */
    public const CBL_LOGISTICA = 'CBL_LOGISTICA';

    /**
     * Estafeta (www.estafeta.com).
     */
    public const MEX_ESTAFETA = 'MEX_ESTAFETA';

    /**
     * Austrian Post (Registered).
     */
    public const AU_AUSTRIAN_POST = 'AU_AUSTRIAN_POST';

    /**
     * Rincos.
     */
    public const RINCOS = 'RINCOS';

    /**
     * DHL Netherland.
     */
    public const NLD_DHL = 'NLD_DHL';

    /**
     * Russian post.
     */
    public const RUSSIAN_POST = 'RUSSIAN_POST';

    /**
     * CouriersPlease (couriersplease.com.au).
     */
    public const COURIERS_PLEASE = 'COURIERS_PLEASE';

    /**
     * PostNord Logistics.
     */
    public const POSTNORD_LOGISTICS = 'POSTNORD_LOGISTICS';

    /**
     * Fedex.
     */
    public const FEDEX = 'FEDEX';

    /**
     * DPE Express.
     */
    public const DPE_EXPRESS = 'DPE_EXPRESS';

    /**
     * DPD.
     */
    public const DPD = 'DPD';

    /**
     * ADSone.
     */
    public const ADSONE = 'ADSONE';

    /**
     * JNE Express (Jalur Nugraha Ekakurir).
     */
    public const IDN_JNE = 'IDN_JNE';

    /**
     * The Courier Guy.
     */
    public const THECOURIERGUY = 'THECOURIERGUY';

    /**
     * CNE Express.
     */
    public const CNEXPS = 'CNEXPS';

    /**
     * Chronopost Portugal.
     */
    public const PRT_CHRONOPOST = 'PRT_CHRONOPOST';

    /**
     * Landmark Global.
     */
    public const LANDMARK_GLOBAL = 'LANDMARK_GLOBAL';

    /**
     * DHL International.
     */
    public const IT_DHL_ECOMMERCE = 'IT_DHL_ECOMMERCE';

    /**
     * NACEX Spain.
     */
    public const ESP_NACEX = 'ESP_NACEX';

    /**
     * CTT Portugal.
     */
    public const PRT_CTT = 'PRT_CTT';

    /**
     * Kiala.
     */
    public const BE_KIALA = 'BE_KIALA';

    /**
     * Asendia UK.
     */
    public const ASENDIA_UK = 'ASENDIA_UK';

    /**
     * TNT global.
     */
    public const GLOBAL_TNT = 'GLOBAL_TNT';

    /**
     * Iceland Post.
     */
    public const POSTUR_IS = 'POSTUR_IS';

    /**
     * eParcel Korea.
     */
    public const EPARCEL_KR = 'EPARCEL_KR';

    /**
     * InPost Paczkomaty.
     */
    public const INPOST_PACZKOMATY = 'INPOST_PACZKOMATY';

    /**
     * Poste italiane (www.poste.it).
     */
    public const IT_POSTE_ITALIA = 'IT_POSTE_ITALIA';

    /**
     * Bpost (www.bpost.be).
     */
    public const BE_BPOST = 'BE_BPOST';

    /**
     * Poczta Polska (www.poczta-polska.pl).
     */
    public const PL_POCZTA_POLSKA = 'PL_POCZTA_POLSKA';

    /**
     * Malaysia Post.
     */
    public const MYS_MYS_POST = 'MYS_MYS_POST';

    /**
     * Singapore Post.
     */
    public const SG_SG_POST = 'SG_SG_POST';

    /**
     * Thailand Post (www.thailandpost.co.th).
     */
    public const THA_THAILAND_POST = 'THA_THAILAND_POST';

    /**
     * LexShip.
     */
    public const LEXSHIP = 'LEXSHIP';

    /**
     * Fastway New Zealand.
     */
    public const FASTWAY_NZ = 'FASTWAY_NZ';

    /**
     * DHL Supply Chain Australia.
     */
    public const DHL_AU = 'DHL_AU';

    /**
     * Cosmetics Now.
     */
    public const COSTMETICSNOW = 'COSTMETICSNOW';

    /**
     * PFL.
     */
    public const PFLOGISTICS = 'PFLOGISTICS';

    /**
     * Loomis Express.
     */
    public const LOOMIS_EXPRESS = 'LOOMIS_EXPRESS';

    /**
     * GLS Italy.
     */
    public const GLS_ITALY = 'GLS_ITALY';

    /**
     * Line Clear Express & Logistics Sdn Bhd.
     */
    public const LINE = 'LINE';

    /**
     * Gel Express Logistik.
     */
    public const GEL_EXPRESS = 'GEL_EXPRESS';

    /**
     * Huodull.
     */
    public const HUODULL = 'HUODULL';

    /**
     * Ninja van Singapore.
     */
    public const NINJAVAN_SG = 'NINJAVAN_SG';

    /**
     * Janio Asia.
     */
    public const JANIO = 'JANIO';

    /**
     * AO Logistics.
     */
    public const AO_COURIER = 'AO_COURIER';

    /**
     * BRT Bartolini(Sender Reference).
     */
    public const BRT_IT_SENDER_REF = 'BRT_IT_SENDER_REF';

    /**
     * SAILPOST.
     */
    public const SAILPOST = 'SAILPOST';

    /**
     * Lalamove.
     */
    public const LALAMOVE = 'LALAMOVE';

    /**
     * NEW ZEALAND COURIERS.
     */
    public const NEWZEALAND_COURIERS = 'NEWZEALAND_COURIERS';

    /**
     * Etomars.
     */
    public const ETOMARS = 'ETOMARS';

    /**
     * VIR Transport.
     */
    public const VIRTRANSPORT = 'VIRTRANSPORT';

    /**
     * Wizmo.
     */
    public const WIZMO = 'WIZMO';

    /**
     * Palletways.
     */
    public const PALLETWAYS = 'PALLETWAYS';

    /**
     * i-dika.
     */
    public const I_DIKA = 'I_DIKA';

    /**
     * CFL Logistics.
     */
    public const CFL_LOGISTICS = 'CFL_LOGISTICS';

    /**
     * GEM Worldwide.
     */
    public const GEMWORLDWIDE = 'GEMWORLDWIDE';

    /**
     * Tai Wan Global Business.
     */
    public const GLOBAL_EXPRESS = 'GLOBAL_EXPRESS';

    /**
     * Transgroup courier.
     */
    public const LOGISTYX_TRANSGROUP = 'LOGISTYX_TRANSGROUP';

    /**
     * West Bank Courier.
     */
    public const WESTBANK_COURIER = 'WESTBANK_COURIER';

    /**
     * Arco Spedizioni SP.
     */
    public const ARCO_SPEDIZIONI = 'ARCO_SPEDIZIONI';

    /**
     * YDH express.
     */
    public const YDH_EXPRESS = 'YDH_EXPRESS';

    /**
     * Parcelink Logistics.
     */
    public const PARCELINKLOGISTICS = 'PARCELINKLOGISTICS';

    /**
     * CND Express.
     */
    public const CNDEXPRESS = 'CNDEXPRESS';

    /**
     * NOX NightTimeExpress.
     */
    public const NOX_NIGHT_TIME_EXPRESS = 'NOX_NIGHT_TIME_EXPRESS';

    /**
     * Aeronet couriers.
     */
    public const AERONET = 'AERONET';

    /**
     * LTIAN EXP.
     */
    public const LTIANEXP = 'LTIANEXP';

    /**
     * Integra2.
     */
    public const INTEGRA2_FTP = 'INTEGRA2_FTP';

    /**
     * PARCEL ONE.
     */
    public const PARCELONE = 'PARCELONE';

    /**
     * Innight Express Germany GmbH (nox NachtExpress).
     */
    public const NOX_NACHTEXPRESS = 'NOX_NACHTEXPRESS';

    /**
     * China Post.
     */
    public const CN_CHINA_POST_EMS = 'CN_CHINA_POST_EMS';

    /**
     * Chukou1.
     */
    public const CHUKOU1 = 'CHUKOU1';

    /**
     * GLS General Logistics Systems Slovakia s.r.o..
     */
    public const GLS_SLOV = 'GLS_SLOV';

    /**
     * OrangeDS (Orange Distribution Solutions Inc).
     */
    public const ORANGE_DS = 'ORANGE_DS';

    /**
     * Joom Logistics.
     */
    public const JOOM_LOGIS = 'JOOM_LOGIS';

    /**
     * StarTrack (startrack.com.au).
     */
    public const AUS_STARTRACK = 'AUS_STARTRACK';

    /**
     * dhl Global.
     */
    public const DHL = 'DHL';

    /**
     * APC postal logistics germany.
     */
    public const GB_APC = 'GB_APC';

    /**
     * Bonds Courier Service (bondscouriers.com.au).
     */
    public const BONDSCOURIERS = 'BONDSCOURIERS';

    /**
     * Japan Post.
     */
    public const JPN_JAPAN_POST = 'JPN_JAPAN_POST';

    /**
     * United States Postal Service.
     */
    public const USPS = 'USPS';

    /**
     * WinIt.
     */
    public const WINIT = 'WINIT';

    /**
     * OCA Argentina.
     */
    public const ARG_OCA = 'ARG_OCA';

    /**
     * Taiwan Post.
     */
    public const TW_TAIWAN_POST = 'TW_TAIWAN_POST';

    /**
     * DMM Network.
     */
    public const DMM_NETWORK = 'DMM_NETWORK';

    /**
     * TNT Express.
     */
    public const TNT = 'TNT';

    /**
     * BH Posta (www.posta.ba).
     */
    public const BH_POSTA = 'BH_POSTA';

    /**
     * Postnord sweden.
     */
    public const SWE_POSTNORD = 'SWE_POSTNORD';

    /**
     * Canada Post.
     */
    public const CA_CANADA_POST = 'CA_CANADA_POST';

    /**
     * Wiseloads.
     */
    public const WISELOADS = 'WISELOADS';

    /**
     * Asendia HonKong.
     */
    public const ASENDIA_HK = 'ASENDIA_HK';

    /**
     * GLS Netherland.
     */
    public const NLD_GLS = 'NLD_GLS';

    /**
     * Redpack.
     */
    public const MEX_REDPACK = 'MEX_REDPACK';

    /**
     * Jet-Ship Worldwide.
     */
    public const JET_SHIP = 'JET_SHIP';

    /**
     * DHL Express.
     */
    public const DE_DHL_EXPRESS = 'DE_DHL_EXPRESS';

    /**
     * Ninja van Thai.
     */
    public const NINJAVAN_THAI = 'NINJAVAN_THAI';

    /**
     * Raben Group.
     */
    public const RABEN_GROUP = 'RABEN_GROUP';

    /**
     * ASM(GLS Spain).
     */
    public const ESP_ASM = 'ESP_ASM';

    /**
     * Hrvatska posta.
     */
    public const HRV_HRVATSKA = 'HRV_HRVATSKA';

    /**
     * Estes Express Lines.
     */
    public const GLOBAL_ESTES = 'GLOBAL_ESTES';

    /**
     * Lietuvos pastas.
     */
    public const LTU_LIETUVOS = 'LTU_LIETUVOS';

    /**
     * DHL Benelux.
     */
    public const BEL_DHL = 'BEL_DHL';

    /**
     * Australia Post.
     */
    public const AU_AU_POST = 'AU_AU_POST';

    /**
     * SPEEDEX couriers.
     */
    public const SPEEDEXCOURIER = 'SPEEDEXCOURIER';

    /**
     * Colissimo.
     */
    public const FR_COLIS = 'FR_COLIS';

    /**
     * Aramex.
     */
    public const ARAMEX = 'ARAMEX';

    /**
     * DPEX (www.dpex.com).
     */
    public const DPEX = 'DPEX';

    /**
     * Airpak Express.
     */
    public const MYS_AIRPAK = 'MYS_AIRPAK';

    /**
     * Cuckoo Express.
     */
    public const CUCKOOEXPRESS = 'CUCKOOEXPRESS';

    /**
     * DPD Poland.
     */
    public const DPD_POLAND = 'DPD_POLAND';

    /**
     * PostNL International.
     */
    public const NLD_POSTNL = 'NLD_POSTNL';

    /**
     * Nim Express.
     */
    public const NIM_EXPRESS = 'NIM_EXPRESS';

    /**
     * Quantium.
     */
    public const QUANTIUM = 'QUANTIUM';

    /**
     * Sendle.
     */
    public const SENDLE = 'SENDLE';

    /**
     * Redur Spain.
     */
    public const ESP_REDUR = 'ESP_REDUR';

    /**
     * Matkahuolto.
     */
    public const MATKAHUOLTO = 'MATKAHUOLTO';

    /**
     * Cpacket couriers.
     */
    public const CPACKET = 'CPACKET';

    /**
     * Posti courier.
     */
    public const POSTI = 'POSTI';

    /**
     * Hunter Express.
     */
    public const HUNTER_EXPRESS = 'HUNTER_EXPRESS';

    /**
     * Choir Express Indonesia.
     */
    public const CHOIR_EXP = 'CHOIR_EXP';

    /**
     * Legion Express.
     */
    public const LEGION_EXPRESS = 'LEGION_EXPRESS';

    /**
     * austrian post.
     */
    public const AUSTRIAN_POST_EXPRESS = 'AUSTRIAN_POST_EXPRESS';

    /**
     * Grupo ampm.
     */
    public const GRUPO = 'GRUPO';

    /**
     * Post Roman (www.posta-romana.ro).
     */
    public const POSTA_RO = 'POSTA_RO';

    /**
     * Interparcel UK.
     */
    public const INTERPARCEL_UK = 'INTERPARCEL_UK';

    /**
     * ABF Freight.
     */
    public const GLOBAL_ABF = 'GLOBAL_ABF';

    /**
     * Posten Norge (www.posten.no).
     */
    public const POSTEN_NORGE = 'POSTEN_NORGE';

    /**
     * Xpert Delivery.
     */
    public const XPERT_DELIVERY = 'XPERT_DELIVERY';

    /**
     * DHl (Reference number).
     */
    public const DHL_REFR = 'DHL_REFR';

    /**
     * DHL HonKong.
     */
    public const DHL_HK = 'DHL_HK';

    /**
     * SKYNET UAE.
     */
    public const SKYNET_UAE = 'SKYNET_UAE';

    /**
     * Gojek.
     */
    public const GOJEK = 'GOJEK';

    /**
     * Yodel International.
     */
    public const YODEL_INTNL = 'YODEL_INTNL';

    /**
     * Janco Ecommerce.
     */
    public const JANCO = 'JANCO';

    /**
     * YTO Express.
     */
    public const YTO = 'YTO';

    /**
     * Wise Express.
     */
    public const WISE_EXPRESS = 'WISE_EXPRESS';

    /**
     * J&T Express Vietnam.
     */
    public const JTEXPRESS_VN = 'JTEXPRESS_VN';

    /**
     * FedEx International MailService.
     */
    public const FEDEX_INTL_MLSERV = 'FEDEX_INTL_MLSERV';

    /**
     * VAMOX.
     */
    public const VAMOX = 'VAMOX';

    /**
     * AMS Group.
     */
    public const AMS_GRP = 'AMS_GRP';

    /**
     * DHL Japan.
     */
    public const DHL_JP = 'DHL_JP';

    /**
     * HR Parcel.
     */
    public const HRPARCEL = 'HRPARCEL';

    /**
     * GESWL Express.
     */
    public const GESWL = 'GESWL';

    /**
     * Blue Star.
     */
    public const BLUESTAR = 'BLUESTAR';

    /**
     * CDEK TR.
     */
    public const CDEK_TR = 'CDEK_TR';

    /**
     * Innovel courier.
     */
    public const DESCARTES = 'DESCARTES';

    /**
     * Deltec Courier.
     */
    public const DELTEC_UK = 'DELTEC_UK';

    /**
     * DTDC express.
     */
    public const DTDC_EXPRESS = 'DTDC_EXPRESS';

    /**
     * tourline.
     */
    public const TOURLINE = 'TOURLINE';

    /**
     * B&H Worldwide.
     */
    public const BH_WORLDWIDE = 'BH_WORLDWIDE';

    /**
     * OCS ANA Group.
     */
    public const OCS = 'OCS';

    /**
     * yingnuo logistics.
     */
    public const YINGNUO_LOGISTICS = 'YINGNUO_LOGISTICS';

    /**
     * United Parcel Service.
     */
    public const UPS = 'UPS';

    /**
     * Toll IPEC.
     */
    public const TOLL = 'TOLL';

    /**
     * SEUR portugal.
     */
    public const PRT_SEUR = 'PRT_SEUR';

    /**
     * DTDC Australia.
     */
    public const DTDC_AU = 'DTDC_AU';

    /**
     * Dynamic Logistics.
     */
    public const THA_DYNAMIC_LOGISTICS = 'THA_DYNAMIC_LOGISTICS';

    /**
     * UBI Smart Parcel.
     */
    public const UBI_LOGISTICS = 'UBI_LOGISTICS';

    /**
     * FedEx Cross Border.
     */
    public const FEDEX_CROSSBORDER = 'FEDEX_CROSSBORDER';

    /**
     * A1Post.
     */
    public const A1POST = 'A1POST';

    /**
     * Tazmanian Freight Systems.
     */
    public const TAZMANIAN_FREIGHT = 'TAZMANIAN_FREIGHT';

    /**
     * CJ International malaysia.
     */
    public const CJ_INT_MY = 'CJ_INT_MY';

    /**
     * Saia LTL Freight.
     */
    public const SAIA_FREIGHT = 'SAIA_FREIGHT';

    /**
     * Qxpress.
     */
    public const SG_QXPRESS = 'SG_QXPRESS';

    /**
     * Nhans Solutions.
     */
    public const NHANS_SOLUTIONS = 'NHANS_SOLUTIONS';

    /**
     * DPD France.
     */
    public const DPD_FR = 'DPD_FR';

    /**
     * Coordinadora.
     */
    public const COORDINADORA = 'COORDINADORA';

    /**
     * Grupo logistico Andreani.
     */
    public const ANDREANI = 'ANDREANI';

    /**
     * Doora Logistics.
     */
    public const DOORA = 'DOORA';

    /**
     * Interparcel New Zealand.
     */
    public const INTERPARCEL_NZ = 'INTERPARCEL_NZ';

    /**
     * Jam Express Philippines.
     */
    public const PHL_JAMEXPRESS = 'PHL_JAMEXPRESS';

    /**
     * bel_belgium_post.
     */
    public const BEL_BELGIUM_POST = 'BEL_BELGIUM_POST';

    /**
     * us_apc.
     */
    public const US_APC = 'US_APC';

    /**
     * idn_pos.
     */
    public const IDN_POS = 'IDN_POS';

    /**
     * fr_mondial.
     */
    public const FR_MONDIAL = 'FR_MONDIAL';

    /**
     * DE DHL.
     */
    public const DE_DHL = 'DE_DHL';

    /**
     * hk_rpx.
     */
    public const HK_RPX = 'HK_RPX';

    /**
     * dhl_pieceid.
     */
    public const DHL_PIECEID = 'DHL_PIECEID';

    /**
     * vnpost_ems.
     */
    public const VNPOST_EMS = 'VNPOST_EMS';

    /**
     * rrdonnelley.
     */
    public const RRDONNELLEY = 'RRDONNELLEY';

    /**
     * dpd_de.
     */
    public const DPD_DE = 'DPD_DE';

    /**
     * delcart_in.
     */
    public const DELCART_IN = 'DELCART_IN';

    /**
     * imexglobalsolutions.
     */
    public const IMEXGLOBALSOLUTIONS = 'IMEXGLOBALSOLUTIONS';

    /**
     * ACOMMERCE.
     */
    public const ACOMMERCE = 'ACOMMERCE';

    /**
     * eurodis.
     */
    public const EURODIS = 'EURODIS';

    /**
     * CANPAR.
     */
    public const CANPAR = 'CANPAR';

    /**
     * GLS.
     */
    public const GLS = 'GLS';

    /**
     * Ecom Express.
     */
    public const IND_ECOM = 'IND_ECOM';

    /**
     * Envialia.
     */
    public const ESP_ENVIALIA = 'ESP_ENVIALIA';

    /**
     * dhl UK.
     */
    public const DHL_UK = 'DHL_UK';

    /**
     * SMSA Express.
     */
    public const SMSA_EXPRESS = 'SMSA_EXPRESS';

    /**
     * TNT France.
     */
    public const TNT_FR = 'TNT_FR';

    /**
     * DEX-I courier.
     */
    public const DEX_I = 'DEX_I';

    /**
     * Budbee courier.
     */
    public const BUDBEE_WEBHOOK = 'BUDBEE_WEBHOOK';

    /**
     * Copa Airlines Courier.
     */
    public const COPA_COURIER = 'COPA_COURIER';

    /**
     * Vietnam Post.
     */
    public const VNM_VIETNAM_POST = 'VNM_VIETNAM_POST';

    /**
     * DPD HongKong.
     */
    public const DPD_HK = 'DPD_HK';

    /**
     * Toll New Zealand.
     */
    public const TOLL_NZ = 'TOLL_NZ';

    /**
     * Echo courier.
     */
    public const ECHO_ = 'ECHO';

    /**
     * FedEx® Freight.
     */
    public const FEDEX_FR = 'FEDEX_FR';

    /**
     * Border Express.
     */
    public const BORDEREXPRESS = 'BORDEREXPRESS';

    /**
     * MailPlus (Japan).
     */
    public const MAILPLUS_JPN = 'MAILPLUS_JPN';

    /**
     * TNT UK Reference.
     */
    public const TNT_UK_REFR = 'TNT_UK_REFR';

    /**
     * KEC courier.
     */
    public const KEC = 'KEC';

    /**
     * DPD Romania.
     */
    public const DPD_RO = 'DPD_RO';

    /**
     * TNT_JP.
     */
    public const TNT_JP = 'TNT_JP';

    /**
     * TH_CJ.
     */
    public const TH_CJ = 'TH_CJ';

    /**
     * EC_CN.
     */
    public const EC_CN = 'EC_CN';

    /**
     * FASTWAY_UK.
     */
    public const FASTWAY_UK = 'FASTWAY_UK';

    /**
     * FASTWAY_US.
     */
    public const FASTWAY_US = 'FASTWAY_US';

    /**
     * GLS_DE.
     */
    public const GLS_DE = 'GLS_DE';

    /**
     * GLS_ES.
     */
    public const GLS_ES = 'GLS_ES';

    /**
     * GLS_FR.
     */
    public const GLS_FR = 'GLS_FR';

    /**
     * MONDIAL_BE.
     */
    public const MONDIAL_BE = 'MONDIAL_BE';

    /**
     * SGT_IT.
     */
    public const SGT_IT = 'SGT_IT';

    /**
     * TNT_CN.
     */
    public const TNT_CN = 'TNT_CN';

    /**
     * TNT_DE.
     */
    public const TNT_DE = 'TNT_DE';

    /**
     * TNT_ES.
     */
    public const TNT_ES = 'TNT_ES';

    /**
     * TNT_PL.
     */
    public const TNT_PL = 'TNT_PL';

    /**
     * PARCELFORCE.
     */
    public const PARCELFORCE = 'PARCELFORCE';

    /**
     * SWISS POST.
     */
    public const SWISS_POST = 'SWISS_POST';

    /**
     * TOLL IPEC.
     */
    public const TOLL_IPEC = 'TOLL_IPEC';

    /**
     * AIR 21.
     */
    public const AIR_21 = 'AIR_21';

    /**
     * AIRSPEED.
     */
    public const AIRSPEED = 'AIRSPEED';

    /**
     * BERT.
     */
    public const BERT = 'BERT';

    /**
     * BLUEDART.
     */
    public const BLUEDART = 'BLUEDART';

    /**
     * COLLECTPLUS.
     */
    public const COLLECTPLUS = 'COLLECTPLUS';

    /**
     * COURIERPLUS.
     */
    public const COURIERPLUS = 'COURIERPLUS';

    /**
     * COURIER POST.
     */
    public const COURIER_POST = 'COURIER_POST';

    /**
     * dhl_global_mail.
     */
    public const DHL_GLOBAL_MAIL = 'DHL_GLOBAL_MAIL';

    /**
     * dpd_uk.
     */
    public const DPD_UK = 'DPD_UK';

    /**
     * DELTEC DE.
     */
    public const DELTEC_DE = 'DELTEC_DE';

    /**
     * deutsche_de.
     */
    public const DEUTSCHE_DE = 'DEUTSCHE_DE';

    /**
     * DOTZOT.
     */
    public const DOTZOT = 'DOTZOT';

    /**
     * elta_gr.
     */
    public const ELTA_GR = 'ELTA_GR';

    /**
     * ems_cn.
     */
    public const EMS_CN = 'EMS_CN';

    /**
     * ECARGO.
     */
    public const ECARGO = 'ECARGO';

    /**
     * ENSENDA.
     */
    public const ENSENDA = 'ENSENDA';

    /**
     * fercam_it.
     */
    public const FERCAM_IT = 'FERCAM_IT';

    /**
     * fastway_za.
     */
    public const FASTWAY_ZA = 'FASTWAY_ZA';

    /**
     * fastway_au.
     */
    public const FASTWAY_AU = 'FASTWAY_AU';

    /**
     * first_logisitcs.
     */
    public const FIRST_LOGISITCS = 'FIRST_LOGISITCS';

    /**
     * GEODIS.
     */
    public const GEODIS = 'GEODIS';

    /**
     * GLOBEGISTICS.
     */
    public const GLOBEGISTICS = 'GLOBEGISTICS';

    /**
     * GREYHOUND.
     */
    public const GREYHOUND = 'GREYHOUND';

    /**
     * jetship_my.
     */
    public const JETSHIP_MY = 'JETSHIP_MY';

    /**
     * LION PARCEL.
     */
    public const LION_PARCEL = 'LION_PARCEL';

    /**
     * AEROFLASH.
     */
    public const AEROFLASH = 'AEROFLASH';

    /**
     * ONTRAC.
     */
    public const ONTRAC = 'ONTRAC';

    /**
     * SAGAWA.
     */
    public const SAGAWA = 'SAGAWA';

    /**
     * SIODEMKA.
     */
    public const SIODEMKA = 'SIODEMKA';

    /**
     * startrack.
     */
    public const STARTRACK = 'STARTRACK';

    /**
     * tnt_au.
     */
    public const TNT_AU = 'TNT_AU';

    /**
     * tnt_it.
     */
    public const TNT_IT = 'TNT_IT';

    /**
     * TRANSMISSION.
     */
    public const TRANSMISSION = 'TRANSMISSION';

    /**
     * YAMATO.
     */
    public const YAMATO = 'YAMATO';

    /**
     * dhl_it.
     */
    public const DHL_IT = 'DHL_IT';

    /**
     * dhl_at.
     */
    public const DHL_AT = 'DHL_AT';

    /**
     * LOGISTICSWORLDWIDE KR.
     */
    public const LOGISTICSWORLDWIDE_KR = 'LOGISTICSWORLDWIDE_KR';

    /**
     * gls_spain.
     */
    public const GLS_SPAIN = 'GLS_SPAIN';

    /**
     * amazon_uk_api.
     */
    public const AMAZON_UK_API = 'AMAZON_UK_API';

    /**
     * dpd_fr_reference.
     */
    public const DPD_FR_REFERENCE = 'DPD_FR_REFERENCE';

    /**
     * dhlparcel_uk.
     */
    public const DHLPARCEL_UK = 'DHLPARCEL_UK';

    /**
     * megasave.
     */
    public const MEGASAVE = 'MEGASAVE';

    /**
     * qualitypost.
     */
    public const QUALITYPOST = 'QUALITYPOST';

    /**
     * ids_logistics.
     */
    public const IDS_LOGISTICS = 'IDS_LOGISTICS';

    /**
     * joyingbox.
     */
    public const JOYINGBOX1 = 'JOYINGBOX';

    /**
     * panther_order_number.
     */
    public const PANTHER_ORDER_NUMBER = 'PANTHER_ORDER_NUMBER';

    /**
     * watkins_shepard.
     */
    public const WATKINS_SHEPARD = 'WATKINS_SHEPARD';

    /**
     * fasttrack.
     */
    public const FASTTRACK = 'FASTTRACK';

    /**
     * up_express.
     */
    public const UP_EXPRESS = 'UP_EXPRESS';

    /**
     * elogistica.
     */
    public const ELOGISTICA = 'ELOGISTICA';

    /**
     * ecourier.
     */
    public const ECOURIER = 'ECOURIER';

    /**
     * cj_philippines.
     */
    public const CJ_PHILIPPINES = 'CJ_PHILIPPINES';

    /**
     * speedex.
     */
    public const SPEEDEX = 'SPEEDEX';

    /**
     * orangeconnex.
     */
    public const ORANGECONNEX = 'ORANGECONNEX';

    /**
     * tecor.
     */
    public const TECOR = 'TECOR';

    /**
     * saee.
     */
    public const SAEE = 'SAEE';

    /**
     * gls_italy_ftp.
     */
    public const GLS_ITALY_FTP = 'GLS_ITALY_FTP';

    /**
     * delivere.
     */
    public const DELIVERE = 'DELIVERE';

    /**
     * yycom.
     */
    public const YYCOM = 'YYCOM';

    /**
     * Adicional Logistics.
     */
    public const ADICIONAL_PT = 'ADICIONAL_PT';

    /**
     * DKSH.
     */
    public const DKSH = 'DKSH';

    /**
     * Nippon Express.
     */
    public const NIPPON_EXPRESS_FTP = 'NIPPON_EXPRESS_FTP';

    /**
     * GO Logistics & Storage.
     */
    public const GOLS = 'GOLS';

    /**
     * FUJIE EXPRESS.
     */
    public const FUJEXP = 'FUJEXP';

    /**
     * QTrack.
     */
    public const QTRACK = 'QTRACK';

    /**
     * OM LOGISTICS LTD.
     */
    public const OMLOGISTICS_API = 'OMLOGISTICS_API';

    /**
     * GDPharm Logistics.
     */
    public const GDPHARM = 'GDPHARM';

    /**
     * MISUMI Group Inc..
     */
    public const MISUMI_CN = 'MISUMI_CN';

    /**
     * Rivo.
     */
    public const AIR_CANADA = 'AIR_CANADA';

    /**
     * City Express.
     */
    public const CITY56_WEBHOOK = 'CITY56_WEBHOOK';

    /**
     * Sagawa.
     */
    public const SAGAWA_API = 'SAGAWA_API';

    /**
     * KedaEX.
     */
    public const KEDAEX = 'KEDAEX';

    /**
     * Pgeon.
     */
    public const PGEON_API = 'PGEON_API';

    /**
     * We World Express.
     */
    public const WEWORLDEXPRESS = 'WEWORLDEXPRESS';

    /**
     * J&T International logistics.
     */
    public const JT_LOGISTICS = 'JT_LOGISTICS';

    /**
     * Trusk France.
     */
    public const TRUSK = 'TRUSK';

    /**
     * ViaXpress.
     */
    public const VIAXPRESS = 'VIAXPRESS';

    /**
     * DHL Supply Chain Indonesia.
     */
    public const DHL_SUPPLYCHAIN_ID = 'DHL_SUPPLYCHAIN_ID';

    /**
     * Zuellig Pharma Korea.
     */
    public const ZUELLIGPHARMA_SFTP = 'ZUELLIGPHARMA_SFTP';

    /**
     * Meest.
     */
    public const MEEST = 'MEEST';

    /**
     * Toll Priority.
     */
    public const TOLL_PRIORITY = 'TOLL_PRIORITY';

    /**
     * Mothership.
     */
    public const MOTHERSHIP_API = 'MOTHERSHIP_API';

    /**
     * Capital Transport.
     */
    public const CAPITAL = 'CAPITAL';

    /**
     * Europacket+.
     */
    public const EUROPAKET_API = 'EUROPAKET_API';

    /**
     * HFD.
     */
    public const HFD = 'HFD';

    /**
     * Tourline Express.
     */
    public const TOURLINE_REFERENCE = 'TOURLINE_REFERENCE';

    /**
     * GIO Express Inc.
     */
    public const GIO_ECOURIER = 'GIO_ECOURIER';

    /**
     * CN Logistics.
     */
    public const CN_LOGISTICS = 'CN_LOGISTICS';

    /**
     * Pandion.
     */
    public const PANDION = 'PANDION';

    /**
     * Bpost API.
     */
    public const BPOST_API = 'BPOST_API';

    /**
     * Passport Shipping.
     */
    public const PASSPORTSHIPPING = 'PASSPORTSHIPPING';

    /**
     * Pakajo World.
     */
    public const PAKAJO = 'PAKAJO';

    /**
     * DACHSER.
     */
    public const DACHSER = 'DACHSER';

    /**
     * Yusen Logistics.
     */
    public const YUSEN_SFTP = 'YUSEN_SFTP';

    /**
     * Shypmax.
     */
    public const SHYPLITE = 'SHYPLITE';

    /**
     * Xingyunyi Logistics.
     */
    public const XYY = 'XYY';

    /**
     * Metropolitan Warehouse & Delivery.
     */
    public const MWD = 'MWD';

    /**
     * Faxe Cargo.
     */
    public const FAXECARGO = 'FAXECARGO';

    /**
     * Groupe Mazet.
     */
    public const MAZET = 'MAZET';

    /**
     * First Logistics.
     */
    public const FIRST_LOGISTICS_API = 'FIRST_LOGISTICS_API';

    /**
     * SPRINT PACK.
     */
    public const SPRINT_PACK = 'SPRINT_PACK';

    /**
     * Hermes Germany.
     */
    public const HERMES_DE_FTP = 'HERMES_DE_FTP';

    /**
     * Concise.
     */
    public const CONCISE = 'CONCISE';

    /**
     * Kerry Express TaiWan.
     */
    public const KERRY_EXPRESS_TW_API = 'KERRY_EXPRESS_TW_API';

    /**
     * EWE Global Express.
     */
    public const EWE = 'EWE';

    /**
     * Fast Despatch Logistics Limited.
     */
    public const FASTDESPATCH = 'FASTDESPATCH';

    /**
     * AB Custom Group.
     */
    public const ABCUSTOM_SFTP = 'ABCUSTOM_SFTP';

    /**
     * Chazki.
     */
    public const CHAZKI = 'CHAZKI';

    /**
     * Shippie.
     */
    public const SHIPPIE = 'SHIPPIE';

    /**
     * GEODIS - Distribution & Express.
     */
    public const GEODIS_API = 'GEODIS_API';

    /**
     * Naqel Express.
     */
    public const NAQEL_EXPRESS = 'NAQEL_EXPRESS';

    /**
     * Papa.
     */
    public const PAPA_WEBHOOK = 'PAPA_WEBHOOK';

    /**
     * Forward Air.
     */
    public const FORWARDAIR = 'FORWARDAIR';

    /**
     * Dialogo Logistica.
     */
    public const DIALOGO_LOGISTICA_API = 'DIALOGO_LOGISTICA_API';

    /**
     * Lalamove.
     */
    public const LALAMOVE_API = 'LALAMOVE_API';

    /**
     * Tomydoor.
     */
    public const TOMYDOOR = 'TOMYDOOR';

    /**
     * Kronos Express.
     */
    public const KRONOS_WEBHOOK = 'KRONOS_WEBHOOK';

    /**
     * J&T CARGO.
     */
    public const JTCARGO = 'JTCARGO';

    /**
     * T-cat.
     */
    public const T_CAT = 'T_CAT';

    /**
     * Concise.
     */
    public const CONCISE_WEBHOOK = 'CONCISE_WEBHOOK';

    /**
     * Teleport.
     */
    public const TELEPORT_WEBHOOK = 'TELEPORT_WEBHOOK';

    /**
     * The Custom Companies.
     */
    public const CUSTOMCO_API = 'CUSTOMCO_API';

    /**
     * Shopee Xpress.
     */
    public const SPX_TH = 'SPX_TH';

    /**
     * Bollore Logistics.
     */
    public const BOLLORE_LOGISTICS = 'BOLLORE_LOGISTICS';

    /**
     * ClickLink.
     */
    public const CLICKLINK_SFTP = 'CLICKLINK_SFTP';

    /**
     * M3 Logistics.
     */
    public const M3LOGISTICS = 'M3LOGISTICS';

    /**
     * Vietnam Post.
     */
    public const VNPOST_API = 'VNPOST_API';

    /**
     * Axlehire.
     */
    public const AXLEHIRE_FTP = 'AXLEHIRE_FTP';

    /**
     * Shadowfax.
     */
    public const SHADOWFAX = 'SHADOWFAX';

    /**
     * EVRi.
     */
    public const MYHERMES_UK_API = 'MYHERMES_UK_API';

    /**
     * Daiichi Freight System Inc.
     */
    public const DAIICHI = 'DAIICHI';

    /**
     * Mensajeros Urbanos.
     */
    public const MENSAJEROSURBANOS_API = 'MENSAJEROSURBANOS_API';

    /**
     * PolarSpeed Inc.
     */
    public const POLARSPEED = 'POLARSPEED';

    /**
     * iDexpress Indonesia.
     */
    public const IDEXPRESS_ID = 'IDEXPRESS_ID';

    /**
     * Payo.
     */
    public const PAYO = 'PAYO';

    /**
     * Whistl.
     */
    public const WHISTL_SFTP = 'WHISTL_SFTP';

    /**
     * INTEX Paketdienst GmbH.
     */
    public const INTEX_DE = 'INTEX_DE';

    /**
     * Trans2u.
     */
    public const TRANS2U = 'TRANS2U';

    /**
     * Product Care Services Limited.
     */
    public const PRODUCTCAREGROUP_SFTP = 'PRODUCTCAREGROUP_SFTP';

    /**
     * Big Smart.
     */
    public const BIGSMART = 'BIGSMART';

    /**
     * Expeditors API Reference.
     */
    public const EXPEDITORS_API_REF = 'EXPEDITORS_API_REF';

    /**
     * AIT.
     */
    public const AITWORLDWIDE_API = 'AITWORLDWIDE_API';

    /**
     * World Courier.
     */
    public const WORLDCOURIER = 'WORLDCOURIER';

    /**
     * Quiqup.
     */
    public const QUIQUP = 'QUIQUP';

    /**
     * Agediss.
     */
    public const AGEDISS_SFTP = 'AGEDISS_SFTP';

    /**
     * Andreani.
     */
    public const ANDREANI_API = 'ANDREANI_API';

    /**
     * CRL Express.
     */
    public const CRLEXPRESS = 'CRLEXPRESS';

    /**
     * SMARTCAT.
     */
    public const SMARTCAT = 'SMARTCAT';

    /**
     * Crossflight Limited.
     */
    public const CROSSFLIGHT = 'CROSSFLIGHT';

    /**
     * Pro Carrier.
     */
    public const PROCARRIER = 'PROCARRIER';

    /**
     * DHL (Reference number).
     */
    public const DHL_REFERENCE_API = 'DHL_REFERENCE_API';

    /**
     * Seino.
     */
    public const SEINO_API = 'SEINO_API';

    /**
     * WSP Express.
     */
    public const WSPEXPRESS = 'WSPEXPRESS';

    /**
     * Kronos Express.
     */
    public const KRONOS = 'KRONOS';

    /**
     * Total Express.
     */
    public const TOTAL_EXPRESS_API = 'TOTAL_EXPRESS_API';

    /**
     * PARCLL.
     */
    public const PARCLL = 'PARCLL';

    /**
     * Xpedigo.
     */
    public const XPEDIGO = 'XPEDIGO';

    /**
     * StarTrack.
     */
    public const STAR_TRACK_WEBHOOK = 'STAR_TRACK_WEBHOOK';

    /**
     * Georgian Post.
     */
    public const GPOST = 'GPOST';

    /**
     * UCS.
     */
    public const UCS = 'UCS';

    /**
     * DMF.
     */
    public const DMFGROUP = 'DMFGROUP';

    /**
     * Coordinadora.
     */
    public const COORDINADORA_API = 'COORDINADORA_API';

    /**
     * Marken.
     */
    public const MARKEN = 'MARKEN';

    /**
     * NTL logistics.
     */
    public const NTL = 'NTL';

    /**
     * Red je Pakketje.
     */
    public const REDJEPAKKETJE = 'REDJEPAKKETJE';

    /**
     * Allied Express (FTP).
     */
    public const ALLIED_EXPRESS_FTP = 'ALLIED_EXPRESS_FTP';

    /**
     * Mondial Relay Spain(Punto Pack).
     */
    public const MONDIALRELAY_ES = 'MONDIALRELAY_ES';

    /**
     * Naeko Logistics.
     */
    public const NAEKO_FTP = 'NAEKO_FTP';

    /**
     * Mhi.
     */
    public const MHI = 'MHI';

    /**
     * Shippify, Inc.
     */
    public const SHIPPIFY = 'SHIPPIFY';

    /**
     * Malca Amit.
     */
    public const MALCA_AMIT_API = 'MALCA_AMIT_API';

    /**
     * J&T Express Singapore.
     */
    public const JTEXPRESS_SG_API = 'JTEXPRESS_SG_API';

    /**
     * DACHSER.
     */
    public const DACHSER_WEB = 'DACHSER_WEB';

    /**
     * Flight Logistics Group.
     */
    public const FLIGHTLG = 'FLIGHTLG';

    /**
     * Cago.
     */
    public const CAGO = 'CAGO';

    /**
     * ComOne Express.
     */
    public const COM1EXPRESS = 'COM1EXPRESS';

    /**
     * Tonami.
     */
    public const TONAMI_FTP = 'TONAMI_FTP';

    /**
     * PACKFLEET.
     */
    public const PACKFLEET = 'PACKFLEET';

    /**
     * Purolator International.
     */
    public const PUROLATOR_INTERNATIONAL = 'PUROLATOR_INTERNATIONAL';

    /**
     * Wineshipping.
     */
    public const WINESHIPPING_WEBHOOK = 'WINESHIPPING_WEBHOOK';

    /**
     * DHL Spain Domestic.
     */
    public const DHL_ES_SFTP = 'DHL_ES_SFTP';

    /**
     * 網家速配股份有限公司.
     */
    public const PCHOME_API = 'PCHOME_API';

    /**
     * Czech Post.
     */
    public const CESKAPOSTA_API = 'CESKAPOSTA_API';

    /**
     * Go Rush.
     */
    public const GORUSH = 'GORUSH';

    /**
     * HomeRunner.
     */
    public const HOMERUNNER = 'HOMERUNNER';

    /**
     * Amazon order.
     */
    public const AMAZON_ORDER = 'AMAZON_ORDER';

    /**
     * Estes Forwarding Worldwide.
     */
    public const EFWNOW_API = 'EFWNOW_API';

    /**
     * CBL Logistica (API).
     */
    public const CBL_LOGISTICA_API = 'CBL_LOGISTICA_API';

    /**
     * NimbusPost.
     */
    public const NIMBUSPOST = 'NIMBUSPOST';

    /**
     * Logwin Logistics.
     */
    public const LOGWIN_LOGISTICS = 'LOGWIN_LOGISTICS';

    /**
     * Sequoialog.
     */
    public const NOWLOG_API = 'NOWLOG_API';

    /**
     * DPD Netherlands.
     */
    public const DPD_NL = 'DPD_NL';

    /**
     * Dependable Supply Chain Services.
     */
    public const GODEPENDABLE = 'GODEPENDABLE';

    /**
     * Top Ideal Express.
     */
    public const ESDEX = 'ESDEX';

    /**
     * Kiitäjät.
     */
    public const LOGISYSTEMS_SFTP = 'LOGISYSTEMS_SFTP';

    /**
     * Expeditors.
     */
    public const EXPEDITORS = 'EXPEDITORS';

    /**
     * Snt Global Etrax.
     */
    public const SNTGLOBAL_API = 'SNTGLOBAL_API';

    /**
     * ShipX.
     */
    public const SHIPX = 'SHIPX';

    /**
     * Quickstat Courier LLC.
     */
    public const QINTL_API = 'QINTL_API';

    /**
     * Packs.
     */
    public const PACKS = 'PACKS';

    /**
     * PostNL International.
     */
    public const POSTNL_INTERNATIONAL = 'POSTNL_INTERNATIONAL';

    /**
     * Amazon.
     */
    public const AMAZON_EMAIL_PUSH = 'AMAZON_EMAIL_PUSH';

    /**
     * DHL.
     */
    public const DHL_API = 'DHL_API';

    /**
     * Shopee Express.
     */
    public const SPX = 'SPX';

    /**
     * AxleHire.
     */
    public const AXLEHIRE = 'AXLEHIRE';

    /**
     * ICS COURIER.
     */
    public const ICSCOURIER = 'ICSCOURIER';

    /**
     * Dialogo Logistica.
     */
    public const DIALOGO_LOGISTICA = 'DIALOGO_LOGISTICA';

    /**
     * ShunBang Express.
     */
    public const SHUNBANG_EXPRESS = 'SHUNBANG_EXPRESS';

    /**
     * TCS.
     */
    public const TCS_API = 'TCS_API';

    /**
     * SF Express China.
     */
    public const SF_EXPRESS_CN = 'SF_EXPRESS_CN';

    /**
     * Packeta.
     */
    public const PACKETA = 'PACKETA';

    /**
     * Teliway SIC Express.
     */
    public const SIC_TELIWAY = 'SIC_TELIWAY';

    /**
     * Mondial Relay France.
     */
    public const MONDIALRELAY_FR = 'MONDIALRELAY_FR';

    /**
     * InTime.
     */
    public const INTIME_FTP = 'INTIME_FTP';

    /**
     * 京东物流.
     */
    public const JD_EXPRESS = 'JD_EXPRESS';

    /**
     * Fastbox.
     */
    public const FASTBOX = 'FASTBOX';

    /**
     * Patheon Logistics.
     */
    public const PATHEON = 'PATHEON';

    /**
     * India Post Domestic.
     */
    public const INDIA_POST = 'INDIA_POST';

    /**
     * Tipsa Reference.
     */
    public const TIPSA_REF = 'TIPSA_REF';

    /**
     * Eco Freight.
     */
    public const ECOFREIGHT = 'ECOFREIGHT';

    /**
     * VOX SOLUCION EMPRESARIAL SRL.
     */
    public const VOX = 'VOX';

    /**
     * Direct Freight Express.
     */
    public const DIRECTFREIGHT_AU_REF = 'DIRECTFREIGHT_AU_REF';

    /**
     * Best Transport.
     */
    public const BESTTRANSPORT_SFTP = 'BESTTRANSPORT_SFTP';

    /**
     * Australia Post.
     */
    public const AUSTRALIA_POST_API = 'AUSTRALIA_POST_API';

    /**
     * FragilePAK.
     */
    public const FRAGILEPAK_SFTP = 'FRAGILEPAK_SFTP';

    /**
     * FlipXpress.
     */
    public const FLIPXP = 'FLIPXP';

    /**
     * Value Logistics.
     */
    public const VALUE_WEBHOOK = 'VALUE_WEBHOOK';

    /**
     * Daeshin.
     */
    public const DAESHIN = 'DAESHIN';

    /**
     * Sherpa.
     */
    public const SHERPA = 'SHERPA';

    /**
     * Metropolitan Warehouse & Delivery.
     */
    public const MWD_API = 'MWD_API';

    /**
     * SmartKargo.
     */
    public const SMARTKARGO = 'SMARTKARGO';

    /**
     * DNJ Express.
     */
    public const DNJ_EXPRESS = 'DNJ_EXPRESS';

    /**
     * Go People.
     */
    public const GOPEOPLE = 'GOPEOPLE';

    /**
     * mySendle.
     */
    public const MYSENDLE_API = 'MYSENDLE_API';

    /**
     * Aramex.
     */
    public const ARAMEX_API = 'ARAMEX_API';

    /**
     * Pidge.
     */
    public const PIDGE = 'PIDGE';

    /**
     * TP Logistic.
     */
    public const THAIPARCELS = 'THAIPARCELS';

    /**
     * Panther Reference.
     */
    public const PANTHER_REFERENCE_API = 'PANTHER_REFERENCE_API';

    /**
     * Posta Plus.
     */
    public const POSTAPLUS1 = 'POSTAPLUS';

    /**
     * BUFFALO.
     */
    public const BUFFALO = 'BUFFALO';

    /**
     * U-ENVIOS.
     */
    public const U_ENVIOS = 'U_ENVIOS';

    /**
     * Elite Express.
     */
    public const ELITE_CO = 'ELITE_CO';

    /**
     * Roche Internal Courier.
     */
    public const ROCHE_INTERNAL_SFTP = 'ROCHE_INTERNAL_SFTP';

    /**
     * DB Schenker Iceland.
     */
    public const DBSCHENKER_ICELAND = 'DBSCHENKER_ICELAND';

    /**
     * TNT France Reference.
     */
    public const TNT_FR_REFERENCE = 'TNT_FR_REFERENCE';

    /**
     * Newgistics API.
     */
    public const NEWGISTICSAPI = 'NEWGISTICSAPI';

    /**
     * Glovo.
     */
    public const GLOVO = 'GLOVO';

    /**
     * G.I.G.
     */
    public const GWLOGIS_API = 'GWLOGIS_API';

    /**
     * Spreetail.
     */
    public const SPREETAIL_API = 'SPREETAIL_API';

    /**
     * Moova.
     */
    public const MOOVA = 'MOOVA';

    /**
     * Plycon Transportation Group.
     */
    public const PLYCONGROUP = 'PLYCONGROUP';

    /**
     * USPS Informed Visibility - Webhook.
     */
    public const USPS_WEBHOOK = 'USPS_WEBHOOK';

    /**
     * maergo.
     */
    public const REIMAGINEDELIVERY = 'REIMAGINEDELIVERY';

    /**
     * Eurodifarm.
     */
    public const EDF_FTP = 'EDF_FTP';

    /**
     * DAO365.
     */
    public const DAO365 = 'DAO365';

    /**
     * BioCair.
     */
    public const BIOCAIR_FTP = 'BIOCAIR_FTP';

    /**
     * Ransa.
     */
    public const RANSA_WEBHOOK = 'RANSA_WEBHOOK';

    /**
     * SHIPXPRESS.
     */
    public const SHIPXPRES = 'SHIPXPRES';

    /**
     * Courant Plus.
     */
    public const COURANT_PLUS_API = 'COURANT_PLUS_API';

    /**
     * SHIPA.
     */
    public const SHIPA = 'SHIPA';

    /**
     * Home Logistics.
     */
    public const HOMELOGISTICS = 'HOMELOGISTICS';

    /**
     * DX.
     */
    public const DX = 'DX';

    /**
     * Poste Italiane Paccocelere.
     */
    public const POSTE_ITALIANE_PACCOCELERE = 'POSTE_ITALIANE_PACCOCELERE';

    /**
     * Toll Group.
     */
    public const TOLL_WEBHOOK = 'TOLL_WEBHOOK';

    /**
     * LCT do Brasil.
     */
    public const LCTBR_API = 'LCTBR_API';

    /**
     * DX Freight.
     */
    public const DX_FREIGHT = 'DX_FREIGHT';

    /**
     * DHL Express.
     */
    public const DHL_SFTP = 'DHL_SFTP';

    /**
     * Shiprocket X.
     */
    public const SHIPROCKET = 'SHIPROCKET';

    /**
     * Uber.
     */
    public const UBER_WEBHOOK = 'UBER_WEBHOOK';

    /**
     * Stat Overnight.
     */
    public const STATOVERNIGHT = 'STATOVERNIGHT';

    /**
     * Burd Delivery.
     */
    public const BURD = 'BURD';

    /**
     * Fastship Express.
     */
    public const FASTSHIP = 'FASTSHIP';

    /**
     * IB Venture.
     */
    public const IBVENTURE_WEBHOOK = 'IBVENTURE_WEBHOOK';

    /**
     * Gati-KWE.
     */
    public const GATI_KWE_API = 'GATI_KWE_API';

    /**
     * CryoPDP.
     */
    public const CRYOPDP_FTP = 'CRYOPDP_FTP';

    /**
     * HUBBED.
     */
    public const HUBBED = 'HUBBED';

    /**
     * Tipsa API.
     */
    public const TIPSA_API = 'TIPSA_API';

    /**
     * Aras Cargo.
     */
    public const ARASKARGO = 'ARASKARGO';

    /**
     * Thijs Logistiek.
     */
    public const THIJS_NL = 'THIJS_NL';

    /**
     * ATS Healthcare.
     */
    public const ATSHEALTHCARE_REFERENCE = 'ATSHEALTHCARE_REFERENCE';

    /**
     * 99minutos.
     */
    public const ENUM_99MINUTOS = '99MINUTOS';

    /**
     * Hellenic (Greece) Post.
     */
    public const HELLENIC_POST = 'HELLENIC_POST';

    /**
     * HSM Global.
     */
    public const HSM_GLOBAL = 'HSM_GLOBAL';

    /**
     * MNX.
     */
    public const MNX = 'MNX';

    /**
     * N&M Transfer Co., Inc..
     */
    public const NMTRANSFER = 'NMTRANSFER';

    /**
     * Logysto.
     */
    public const LOGYSTO = 'LOGYSTO';

    /**
     * India Post International.
     */
    public const INDIA_POST_INT = 'INDIA_POST_INT';

    /**
     * Swiship IN.
     */
    public const AMAZON_FBA_SWISHIP_IN = 'AMAZON_FBA_SWISHIP_IN';

    /**
     * SRT Transport.
     */
    public const SRT_TRANSPORT = 'SRT_TRANSPORT';

    /**
     * Bomi Group.
     */
    public const BOMI = 'BOMI';

    /**
     * Deliverr.
     */
    public const DELIVERR_SFTP = 'DELIVERR_SFTP';

    /**
     * HSDEXPRESS.
     */
    public const HSDEXPRESS = 'HSDEXPRESS';

    /**
     * SimpleTire.
     */
    public const SIMPLETIRE_WEBHOOK = 'SIMPLETIRE_WEBHOOK';

    /**
     * Hunter Express.
     */
    public const HUNTER_EXPRESS_SFTP = 'HUNTER_EXPRESS_SFTP';

    /**
     * UPS.
     */
    public const UPS_API = 'UPS_API';

    /**
     * WOO YOUNG LOGISTICS CO.,LTD..
     */
    public const WOOYOUNG_LOGISTICS_SFTP = 'WOOYOUNG_LOGISTICS_SFTP';

    /**
     * PHSE.
     */
    public const PHSE_API = 'PHSE_API';

    /**
     * Wish.
     */
    public const WISH_EMAIL_PUSH = 'WISH_EMAIL_PUSH';

    /**
     * Northline.
     */
    public const NORTHLINE = 'NORTHLINE';

    /**
     * Med Africa Logistics.
     */
    public const MEDAFRICA = 'MEDAFRICA';

    /**
     * DPD Austria.
     */
    public const DPD_AT_SFTP = 'DPD_AT_SFTP';

    /**
     * Anteraja.
     */
    public const ANTERAJA = 'ANTERAJA';

    /**
     * DHL Global Forwarding API.
     */
    public const DHL_GLOBAL_FORWARDING_API = 'DHL_GLOBAL_FORWARDING_API';

    /**
     * LBC EXPRESS INC..
     */
    public const LBCEXPRESS_API = 'LBCEXPRESS_API';

    /**
     * Sims Global.
     */
    public const SIMSGLOBAL = 'SIMSGLOBAL';

    /**
     * CDL Last Mile.
     */
    public const CDLDELIVERS = 'CDLDELIVERS';

    /**
     * TYP.
     */
    public const TYP = 'TYP';

    /**
     * Testing Courier.
     */
    public const TESTING_COURIER_WEBHOOK = 'TESTING_COURIER_WEBHOOK';

    /**
     * Pandago.
     */
    public const PANDAGO_API = 'PANDAGO_API';

    /**
     * Royal Mail.
     */
    public const ROYAL_MAIL_FTP = 'ROYAL_MAIL_FTP';

    /**
     * Thunder Express Australia.
     */
    public const THUNDEREXPRESS = 'THUNDEREXPRESS';

    /**
     * Secretlab.
     */
    public const SECRETLAB_WEBHOOK = 'SECRETLAB_WEBHOOK';

    /**
     * Setel Express.
     */
    public const SETEL = 'SETEL';

    /**
     * JD Worldwide.
     */
    public const JD_WORLDWIDE = 'JD_WORLDWIDE';

    /**
     * DPD Russia.
     */
    public const DPD_RU_API = 'DPD_RU_API';

    /**
     * Argents Express Group.
     */
    public const ARGENTS_WEBHOOK = 'ARGENTS_WEBHOOK';

    /**
     * Post ONE.
     */
    public const POSTONE = 'POSTONE';

    /**
     * Tusk Logistics.
     */
    public const TUSKLOGISTICS = 'TUSKLOGISTICS';

    /**
     * Rhenus Logistics UK.
     */
    public const RHENUS_UK_API = 'RHENUS_UK_API';

    /**
     * Yamato Singapore.
     */
    public const TAQBIN_SG_API = 'TAQBIN_SG_API';

    /**
     * Inntralog GmbH.
     */
    public const INNTRALOG_SFTP = 'INNTRALOG_SFTP';

    /**
     * Day & Ross.
     */
    public const DAYROSS = 'DAYROSS';

    /**
     * Correos Express (API).
     */
    public const CORREOSEXPRESS_API = 'CORREOSEXPRESS_API';

    /**
     * International Seur API.
     */
    public const INTERNATIONAL_SEUR_API = 'INTERNATIONAL_SEUR_API';

    /**
     * Yodel API.
     */
    public const YODEL_API = 'YODEL_API';

    /**
     * Hero Express.
     */
    public const HEROEXPRESS = 'HEROEXPRESS';

    /**
     * DHL supply chain India.
     */
    public const DHL_SUPPLYCHAIN_IN = 'DHL_SUPPLYCHAIN_IN';

    /**
     * Urgent Cargus.
     */
    public const URGENT_CARGUS = 'URGENT_CARGUS';

    /**
     * FRONTdoor Collective.
     */
    public const FRONTDOORCORP = 'FRONTDOORCORP';

    /**
     * J&T Express Philippines.
     */
    public const JTEXPRESS_PH = 'JTEXPRESS_PH';

    /**
     * Parcelstars.
     */
    public const PARCELSTARS_WEBHOOK = 'PARCELSTARS_WEBHOOK';

    /**
     * DPD Slovakia.
     */
    public const DPD_SK_SFTP = 'DPD_SK_SFTP';

    /**
     * Movianto.
     */
    public const MOVIANTO = 'MOVIANTO';

    /**
     * Ozeparts Shipping.
     */
    public const OZEPARTS_SHIPPING = 'OZEPARTS_SHIPPING';

    /**
     * KargomKolay (CargoMini).
     */
    public const KARGOMKOLAY = 'KARGOMKOLAY';

    /**
     * Trunkrs.
     */
    public const TRUNKRS = 'TRUNKRS';

    /**
     * Omni Returns.
     */
    public const OMNIRPS_WEBHOOK = 'OMNIRPS_WEBHOOK';

    /**
     * Chile Express.
     */
    public const CHILEXPRESS = 'CHILEXPRESS';

    /**
     * Testing Courier.
     */
    public const TESTING_COURIER = 'TESTING_COURIER';

    /**
     * JNE (API).
     */
    public const JNE_API = 'JNE_API';

    /**
     * BJS Distribution, Storage & Couriers - FTP.
     */
    public const BJSHOMEDELIVERY_FTP = 'BJSHOMEDELIVERY_FTP';

    /**
     * D Express.
     */
    public const DEXPRESS_WEBHOOK = 'DEXPRESS_WEBHOOK';

    /**
     * USPS API.
     */
    public const USPS_API = 'USPS_API';

    /**
     * TransVirtual.
     */
    public const TRANSVIRTUAL = 'TRANSVIRTUAL';

    /**
     * solistica.
     */
    public const SOLISTICA_API = 'SOLISTICA_API';

    /**
     * Chienventure.
     */
    public const CHIENVENTURE_WEBHOOK = 'CHIENVENTURE_WEBHOOK';

    /**
     * DPD UK.
     */
    public const DPD_UK_SFTP = 'DPD_UK_SFTP';

    /**
     * InPost.
     */
    public const INPOST_UK = 'INPOST_UK';

    /**
     * Javit.
     */
    public const JAVIT = 'JAVIT';

    /**
     * ZTO Express China.
     */
    public const ZTO_DOMESTIC = 'ZTO_DOMESTIC';

    /**
     * DHL Global Forwarding Guatemala.
     */
    public const DHL_GT_API = 'DHL_GT_API';

    /**
     * CEVA Package.
     */
    public const CEVA_TRACKING = 'CEVA_TRACKING';

    /**
     * Komon Express.
     */
    public const KOMON_EXPRESS = 'KOMON_EXPRESS';

    /**
     * East West Courier Pte Ltd.
     */
    public const EASTWESTCOURIER_FTP = 'EASTWESTCOURIER_FTP';

    /**
     * Danniao.
     */
    public const DANNIAO = 'DANNIAO';

    /**
     * Spectran.
     */
    public const SPECTRAN = 'SPECTRAN';

    /**
     * Deliver-iT.
     */
    public const DELIVER_IT = 'DELIVER_IT';

    /**
     * Relais Colis.
     */
    public const RELAISCOLIS = 'RELAISCOLIS';

    /**
     * GLS Spain.
     */
    public const GLS_SPAIN_API = 'GLS_SPAIN_API';

    /**
     * PostPlus.
     */
    public const POSTPLUS = 'POSTPLUS';

    /**
     * Airterra.
     */
    public const AIRTERRA = 'AIRTERRA';

    /**
     * GIO Express Ecourier.
     */
    public const GIO_ECOURIER_API = 'GIO_ECOURIER_API';

    /**
     * DPD Switzerland.
     */
    public const DPD_CH_SFTP = 'DPD_CH_SFTP';

    /**
     * FedEx®.
     */
    public const FEDEX_API = 'FEDEX_API';

    /**
     * INTERSMARTTRANS & SOLUTIONS SL.
     */
    public const INTERSMARTTRANS = 'INTERSMARTTRANS';

    /**
     * Hermes UK.
     */
    public const HERMES_UK_SFTP = 'HERMES_UK_SFTP';

    /**
     * Exelot Ltd..
     */
    public const EXELOT_FTP = 'EXELOT_FTP';

    /**
     * DHL GLOBAL FORWARDING PANAMÁ.
     */
    public const DHL_PA_API = 'DHL_PA_API';

    /**
     * Vir Transport.
     */
    public const VIRTRANSPORT_SFTP = 'VIRTRANSPORT_SFTP';

    /**
     * Worldnet Logistics.
     */
    public const WORLDNET = 'WORLDNET';

    /**
     * Instabox.
     */
    public const INSTABOX_WEBHOOK = 'INSTABOX_WEBHOOK';

    /**
     * Keuhne + Nagel Global.
     */
    public const KNG = 'KNG';

    /**
     * Flash Express.
     */
    public const FLASHEXPRESS_WEBHOOK = 'FLASHEXPRESS_WEBHOOK';

    /**
     * Magyar Posta.
     */
    public const MAGYAR_POSTA_API = 'MAGYAR_POSTA_API';

    /**
     * WeShip.
     */
    public const WESHIP_API = 'WESHIP_API';

    /**
     * Ohi.
     */
    public const OHI_WEBHOOK = 'OHI_WEBHOOK';

    /**
     * MUDITA.
     */
    public const MUDITA = 'MUDITA';

    /**
     * Bluedart.
     */
    public const BLUEDART_API = 'BLUEDART_API';

    /**
     * T-cat.
     */
    public const T_CAT_API = 'T_CAT_API';

    /**
     * ADS Express.
     */
    public const ADS = 'ADS';

    /**
     * HR Parcel.
     */
    public const HERMES_IT = 'HERMES_IT';

    /**
     * FitzMark.
     */
    public const FITZMARK_API = 'FITZMARK_API';

    /**
     * Posti API.
     */
    public const POSTI_API = 'POSTI_API';

    /**
     * SMSA Express.
     */
    public const SMSA_EXPRESS_WEBHOOK = 'SMSA_EXPRESS_WEBHOOK';

    /**
     * Tamer Logistics.
     */
    public const TAMERGROUP_WEBHOOK = 'TAMERGROUP_WEBHOOK';

    /**
     * Livrapide.
     */
    public const LIVRAPIDE = 'LIVRAPIDE';

    /**
     * Nippon Express.
     */
    public const NIPPON_EXPRESS = 'NIPPON_EXPRESS';

    /**
     * Better Trucks.
     */
    public const BETTERTRUCKS = 'BETTERTRUCKS';

    /**
     * FAN COURIER EXPRESS.
     */
    public const FAN = 'FAN';

    /**
     * USPS Flats (Pitney Bowes).
     */
    public const PB_USPSFLATS_FTP = 'PB_USPSFLATS_FTP';

    /**
     * Parcel Right.
     */
    public const PARCELRIGHT = 'PARCELRIGHT';

    /**
     * iThink Logistics.
     */
    public const ITHINKLOGISTICS = 'ITHINKLOGISTICS';

    /**
     * Kerry Logistics.
     */
    public const KERRY_EXPRESS_TH_WEBHOOK = 'KERRY_EXPRESS_TH_WEBHOOK';

    /**
     * eCoutier.
     */
    public const ECOUTIER = 'ECOUTIER';

    /**
     * SENHONG INTERNATIONAL LOGISTICS.
     */
    public const SHOWL = 'SHOWL';

    /**
     * BRT Bartolini API.
     */
    public const BRT_IT_API = 'BRT_IT_API';

    /**
     * Rixon Logistics.
     */
    public const RIXONHK_API = 'RIXONHK_API';

    /**
     * DB Schenker.
     */
    public const DBSCHENKER_API = 'DBSCHENKER_API';

    /**
     * Ilyang logistics.
     */
    public const ILYANGLOGIS = 'ILYANGLOGIS';

    /**
     * Mail Boxes Etc..
     */
    public const MAIL_BOX_ETC = 'MAIL_BOX_ETC';

    /**
     * WeShip.
     */
    public const WESHIP = 'WESHIP';

    /**
     * DHL eCommerce Solutions.
     */
    public const DHL_GLOBAL_MAIL_API = 'DHL_GLOBAL_MAIL_API';

    /**
     * Activos24.
     */
    public const ACTIVOS24_API = 'ACTIVOS24_API';

    /**
     * ATS Healthcare.
     */
    public const ATSHEALTHCARE = 'ATSHEALTHCARE';

    /**
     * Luwjistik.
     */
    public const LUWJISTIK = 'LUWJISTIK';

    /**
     * Gebrüder Weiss.
     */
    public const GW_WORLD = 'GW_WORLD';

    /**
     * fairsenden.
     */
    public const FAIRSENDEN_API = 'FAIRSENDEN_API';

    /**
     * SerVIP.
     */
    public const SERVIP_WEBHOOK = 'SERVIP_WEBHOOK';

    /**
     * Swiship.
     */
    public const SWISHIP = 'SWISHIP';

    /**
     * Transport Ambientales.
     */
    public const TANET = 'TANET';

    /**
     * SHENZHEN HOTSIN CARGO INT'L FORWARDING CO.,LTD.
     */
    public const HOTSIN_CARGO = 'HOTSIN_CARGO';

    /**
     * Direx.
     */
    public const DIREX = 'DIREX';

    /**
     * HuanTong.
     */
    public const HUANTONG = 'HUANTONG';

    /**
     * iMile.
     */
    public const IMILE_API = 'IMILE_API';

    /**
     * Au Express.
     */
    public const AUEXPRESS = 'AUEXPRESS';

    /**
     * NYT SUPPLY CHAIN LOGISTICS Co.,LTD.
     */
    public const NYTLOGISTICS = 'NYTLOGISTICS';

    /**
     * DSV Futurewave.
     */
    public const DSV_REFERENCE = 'DSV_REFERENCE';

    /**
     * Novofarma.
     */
    public const NOVOFARMA_WEBHOOK = 'NOVOFARMA_WEBHOOK';

    /**
     * AIT.
     */
    public const AITWORLDWIDE_SFTP = 'AITWORLDWIDE_SFTP';

    /**
     * Olive.
     */
    public const SHOPOLIVE = 'SHOPOLIVE';

    /**
     * Fast & Furious.
     */
    public const FNF_ZA = 'FNF_ZA';

    /**
     * DHL eCommerce Greater China.
     */
    public const DHL_ECOMMERCE_GC = 'DHL_ECOMMERCE_GC';

    /**
     * Fetchr.
     */
    public const FETCHR = 'FETCHR';

    /**
     * Starlinks Global.
     */
    public const STARLINKS_API = 'STARLINKS_API';

    /**
     * YYEXPRESS.
     */
    public const YYEXPRESS = 'YYEXPRESS';

    /**
     * Servientrega.
     */
    public const SERVIENTREGA = 'SERVIENTREGA';

    /**
     * HanJin.
     */
    public const HANJIN = 'HANJIN';

    /**
     * Spanish Seur.
     */
    public const SPANISH_SEUR_FTP = 'SPANISH_SEUR_FTP';

    /**
     * DX (B2B).
     */
    public const DX_B2B_CONNUM = 'DX_B2B_CONNUM';

    /**
     * Helthjem.
     */
    public const HELTHJEM_API = 'HELTHJEM_API';

    /**
     * Inexpost.
     */
    public const INEXPOST = 'INEXPOST';

    /**
     * A2B Express Logistics.
     */
    public const A2B_BA = 'A2B_BA';

    /**
     * Rhenus Logistics.
     */
    public const RHENUS_GROUP = 'RHENUS_GROUP';

    /**
     * Sber Logistics.
     */
    public const SBERLOGISTICS_RU = 'SBERLOGISTICS_RU';

    /**
     * Malca-Amit.
     */
    public const MALCA_AMIT = 'MALCA_AMIT';

    /**
     * Professional Parcel Logistics.
     */
    public const PPL = 'PPL';

    /**
     * OSM Worldwide.
     */
    public const OSM_WORLDWIDE_SFTP = 'OSM_WORLDWIDE_SFTP';

    /**
     * ACI Logistix.
     */
    public const ACILOGISTIX = 'ACILOGISTIX';

    /**
     * Optima Courier.
     */
    public const OPTIMACOURIER = 'OPTIMACOURIER';

    /**
     * Nova Poshta API.
     */
    public const NOVA_POSHTA_API = 'NOVA_POSHTA_API';

    /**
     * Loggi.
     */
    public const LOGGI = 'LOGGI';

    /**
     * YiFan Express.
     */
    public const YIFAN = 'YIFAN';

    /**
     * My DynaLogic.
     */
    public const MYDYNALOGIC = 'MYDYNALOGIC';

    /**
     * Morning Global.
     */
    public const MORNINGLOBAL = 'MORNINGLOBAL';

    /**
     * Concise.
     */
    public const CONCISE_API = 'CONCISE_API';

    /**
     * Falcon Express.
     */
    public const FXTRAN = 'FXTRAN';

    /**
     * Deliver Your Parcel.
     */
    public const DELIVERYOURPARCEL_ZA = 'DELIVERYOURPARCEL_ZA';

    /**
     * uParcel.
     */
    public const UPARCEL = 'UPARCEL';

    /**
     * Mobi Logistica.
     */
    public const MOBI_BR = 'MOBI_BR';

    /**
     * T&W Delivery.
     */
    public const LOGINEXT_WEBHOOK = 'LOGINEXT_WEBHOOK';

    /**
     * EMS.
     */
    public const EMS = 'EMS';

    /**
     * Speedy.
     */
    public const SPEEDY = 'SPEEDY';

    /**
     * Zoom.
     */
    public const ZOOM_RED = 'ZOOM_RED';

    /**
     * Navlungo.
     */
    public const NAVLUNGO = 'NAVLUNGO';

    /**
     * Castle Parcels.
     */
    public const CASTLEPARCELS = 'CASTLEPARCELS';

    /**
     * Weee.
     */
    public const WEEE = 'WEEE';

    /**
     * Packaly.
     */
    public const PACKALY = 'PACKALY';

    /**
     * Yunhuipost.
     */
    public const YUNHUIPOST = 'YUNHUIPOST';

    /**
     * YouParcel.
     */
    public const YOUPARCEL = 'YOUPARCEL';

    /**
     * Leman.
     */
    public const LEMAN = 'LEMAN';

    /**
     * Moovin.
     */
    public const MOOVIN = 'MOOVIN';

    /**
     * Urb-it.
     */
    public const URB_IT = 'URB_IT';

    /**
     * Multientrega.
     */
    public const MULTIENTREGAPANAMA = 'MULTIENTREGAPANAMA';

    /**
     * Jusdasr.
     */
    public const JUSDASR = 'JUSDASR';

    /**
     * Discount Post.
     */
    public const DISCOUNTPOST = 'DISCOUNTPOST';

    /**
     * Rhenus Logistics UK.
     */
    public const RHENUS_UK = 'RHENUS_UK';

    /**
     * Swiship JP.
     */
    public const SWISHIP_JP = 'SWISHIP_JP';

    /**
     * GLS USA.
     */
    public const GLS_US = 'GLS_US';

    /**
     * Southwestern Motor Transport. Inc.
     */
    public const SMTL = 'SMTL';

    /**
     * Discount Post Emega.
     */
    public const EMEGA = 'EMEGA';

    /**
     * EXPRESSONE Slovenia.
     */
    public const EXPRESSONE_SV = 'EXPRESSONE_SV';

    /**
     * hepsiJET.
     */
    public const HEPSIJET = 'HEPSIJET';

    /**
     * Welivery.
     */
    public const WELIVERY = 'WELIVERY';

    /**
     * Bringer Parcel Services.
     */
    public const BRINGER = 'BRINGER';

    /**
     * EasyRoutes.
     */
    public const EASYROUTES = 'EASYROUTES';

    /**
     * MRW.
     */
    public const MRW = 'MRW';

    /**
     * RPM.
     */
    public const RPM = 'RPM';

    /**
     * DPD Portugal.
     */
    public const DPD_PRT = 'DPD_PRT';

    /**
     * GLS Romania.
     */
    public const GLS_ROMANIA = 'GLS_ROMANIA';

    /**
     * LM Parcel.
     */
    public const LMPARCEL = 'LMPARCEL';

    /**
     * GTA GSM.
     */
    public const GTAGSM = 'GTAGSM';

    /**
     * DOMINO.
     */
    public const DOMINO = 'DOMINO';

    /**
     * eShipper.
     */
    public const ESHIPPER = 'ESHIPPER';

    /**
     * Transpak Inc..
     */
    public const TRANSPAK = 'TRANSPAK';

    /**
     * Xindus.
     */
    public const XINDUS = 'XINDUS';

    /**
     * Aoyue.
     */
    public const AOYUE = 'AOYUE';

    /**
     * Easyparcel.
     */
    public const EASYPARCEL = 'EASYPARCEL';

    /**
     * EXPRESSONE.
     */
    public const EXPRESSONE = 'EXPRESSONE';

    /**
     * Sendeo Kargo.
     */
    public const SENDEO_KARGO = 'SENDEO_KARGO';

    /**
     * Speedaf Express.
     */
    public const SPEEDAF = 'SPEEDAF';

    /**
     * eTower.
     */
    public const ETOWER = 'ETOWER';

    /**
     * GC Express.
     */
    public const GCX = 'GCX';

    /**
     * Ninjavan Vietnam.
     */
    public const NINJAVAN_VN = 'NINJAVAN_VN';

    /**
     * Allegro.
     */
    public const ALLEGRO = 'ALLEGRO';

    /**
     * Jumppoint.
     */
    public const JUMPPOINT = 'JUMPPOINT';

    /**
     * ShipGlobal.
     */
    public const SHIPGLOBAL_US = 'SHIPGLOBAL_US';

    /**
     * Kinisi Transport Pty Ltd.
     */
    public const KINISI = 'KINISI';

    /**
     * Oakh Harbour Freight Lines.
     */
    public const OAKH = 'OAKH';

    /**
     * American West.
     */
    public const AWEST = 'AWEST';

    /**
     * Barsan Global Lojistik.
     */
    public const BARSAN = 'BARSAN';

    /**
     * Energo Logistic.
     */
    public const ENERGOLOGISTIC = 'ENERGOLOGISTIC';

    /**
     * Madrooex.
     */
    public const MADROOEX = 'MADROOEX';

    /**
     * GoBolt.
     */
    public const GOBOLT = 'GOBOLT';

    /**
     * Swiss Universal Express.
     */
    public const SWISS_UNIVERSAL_EXPRESS = 'SWISS_UNIVERSAL_EXPRESS';

    /**
     * IOR Direct Solutions.
     */
    public const IORDIRECT = 'IORDIRECT';

    /**
     * xmszm.
     */
    public const XMSZM = 'XMSZM';

    /**
     * GLS Hungary.
     */
    public const GLS_HUN = 'GLS_HUN';

    /**
     * Sendy Express.
     */
    public const SENDY = 'SENDY';

    /**
     * Brauns Express.
     */
    public const BRAUNSEXPRESS = 'BRAUNSEXPRESS';

    /**
     * Grand Slam Express.
     */
    public const GRANDSLAMEXPRESS = 'GRANDSLAMEXPRESS';

    /**
     * XGS.
     */
    public const XGS = 'XGS';

    /**
     * OTS.
     */
    public const OTSCHILE = 'OTSCHILE';

    /**
     * Pack-Up.
     */
    public const PACK_UP = 'PACK_UP';

    /**
     * Parcelstars.
     */
    public const PARCELSTARS = 'PARCELSTARS';

    /**
     * Team Express Service LLC.
     */
    public const TEAMEXPRESSLLC = 'TEAMEXPRESSLLC';

    /**
     * Asyad Express.
     */
    public const ASYADEXPRESS = 'ASYADEXPRESS';

    /**
     * TDN.
     */
    public const TDN = 'TDN';

    /**
     * Early Bird.
     */
    public const EARLYBIRD = 'EARLYBIRD';

    /**
     * Cacesa.
     */
    public const CACESA = 'CACESA';

    /**
     * Parceljet.
     */
    public const PARCELJET = 'PARCELJET';

    /**
     * MNG Kargo.
     */
    public const MNG_KARGO = 'MNG_KARGO';

    /**
     * Super Pac Line.
     */
    public const SUPERPACKLINE = 'SUPERPACKLINE';

    /**
     * SpeedX.
     */
    public const SPEEDX = 'SPEEDX';

    /**
     * Vesyl.
     */
    public const VESYL = 'VESYL';

    /**
     * Sky King.
     */
    public const SKYKING = 'SKYKING';

    /**
     * DIR.
     */
    public const DIRMENSAJERIA = 'DIRMENSAJERIA';

    /**
     * Netlogix.
     */
    public const NETLOGIXGROUP = 'NETLOGIXGROUP';

    /**
     * ZYEX.
     */
    public const ZYOU = 'ZYOU';

    /**
     * Jawar.
     */
    public const JAWAR = 'JAWAR';

    /**
     * Associate Global Systems.
     */
    public const AGSYSTEMS = 'AGSYSTEMS';

    /**
     * GPS.
     */
    public const GPS = 'GPS';

    /**
     * PTT Kargo.
     */
    public const PTT_KARGO = 'PTT_KARGO';

    /**
     * Maergo.
     */
    public const MAERGO = 'MAERGO';

    /**
     * AICS.
     */
    public const ARIHANTCOURIER = 'ARIHANTCOURIER';

    /**
     * VicTas Freight Express.
     */
    public const VTFE = 'VTFE';

    /**
     * Yunant.
     */
    public const YUNANT = 'YUNANT';

    /**
     * Urbify.
     */
    public const URBIFY = 'URBIFY';

    /**
     * pack-man.
     */
    public const PACK_MAN = 'PACK_MAN';

    /**
     * LIEFERGRUN.
     */
    public const LIEFERGRUN = 'LIEFERGRUN';

    /**
     * Obibox.
     */
    public const OBIBOX = 'OBIBOX';

    /**
     * Paikeda.
     */
    public const PAIKEDA = 'PAIKEDA';

    /**
     * Scotty.
     */
    public const SCOTTY = 'SCOTTY';

    /**
     * Intelcom.
     */
    public const INTELCOM_CA = 'INTELCOM_CA';

    /**
     * swe.
     */
    public const SWE = 'SWE';

    /**
     * Asendia Global.
     */
    public const ASENDIA = 'ASENDIA';

    /**
     * DPD Austria.
     */
    public const DPD_AT = 'DPD_AT';

    /**
     * Relay.
     */
    public const RELAY = 'RELAY';

    /**
     * ATA.
     */
    public const ATA = 'ATA';

    /**
     * SkyExpress Internationals.
     */
    public const SKYEXPRESS_INTERNATIONAL = 'SKYEXPRESS_INTERNATIONAL';

    /**
     * Surat Kargo.
     */
    public const SURAT_KARGO = 'SURAT_KARGO';

    /**
     * SG LINK.
     */
    public const SGLINK = 'SGLINK';

    /**
     * FleetOptics.
     */
    public const FLEETOPTICSINC = 'FLEETOPTICSINC';

    /**
     * shopline.
     */
    public const SHOPLINE = 'SHOPLINE';

    /**
     * PIGGYSHIP.
     */
    public const PIGGYSHIP = 'PIGGYSHIP';

    /**
     * LogoiX.
     */
    public const LOGOIX = 'LOGOIX';

    /**
     * Kolay Gelsin.
     */
    public const KOLAY_GELSIN = 'KOLAY_GELSIN';

    /**
     * Associated Couriers.
     */
    public const ASSOCIATED_COURIERS = 'ASSOCIATED_COURIERS';

    /**
     * ups-checker.
     */
    public const UPS_CHECKER = 'UPS_CHECKER';

    /**
     * Wineshipping.
     */
    public const WINESHIPPING = 'WINESHIPPING';

    /**
     * Spedisci online.
     */
    public const SPEDISCI = 'SPEDISCI';

    /**
     * Fourkites.
     */
    public const FOURKITES = 'FOURKITES';

    /**
     * Etonas.
     */
    public const ETONAS = 'ETONAS';

    /**
     * Fin Mile.
     */
    public const FINMILE = 'FINMILE';

    /**
     * Uniuni.
     */
    public const UNIUNI = 'UNIUNI';

    /**
     * Rodonaves.
     */
    public const RODONAVES = 'RODONAVES';

    /**
     * Inpost Italy.
     */
    public const INPOST_IT = 'INPOST_IT';

    /**
     * Tforce Freight.
     */
    public const TFORCE_FREIGHT = 'TFORCE_FREIGHT';

    /**
     * Rich Mom.
     */
    public const RICHMOM = 'RICHMOM';

    /**
     * Corriere Franco.
     */
    public const FRANCO = 'FRANCO';

    /**
     * Ecparcel.
     */
    public const ECPARCEL = 'ECPARCEL';

    /**
     * Fedex China.
     */
    public const FEDEX_CHINA = 'FEDEX_CHINA';

    /**
     * Gofo Express.
     */
    public const GOFO_EXPRESS = 'GOFO_EXPRESS';

    /**
     * Shipbob.
     */
    public const SHIPBOB = 'SHIPBOB';

    /**
     * Jersey Post Group.
     */
    public const JERSEYPOST_ATLAS = 'JERSEYPOST_ATLAS';

    /**
     * Coretrails.
     */
    public const CORETRAILS = 'CORETRAILS';

    /**
     * Rhenus Logistics Italy.
     */
    public const RHENUS_ITALY = 'RHENUS_ITALY';

    /**
     * Jadlog.
     */
    public const JADLOG = 'JADLOG';

    /**
     * Jitsu.
     */
    public const JITSU = 'JITSU';

    /**
     * Yanwen Express.
     */
    public const YANWEN_EXPRESS = 'YANWEN_EXPRESS';

    /**
     * Dashlink.
     */
    public const DASHLINK = 'DASHLINK';

    /**
     * Seino Super Express.
     */
    public const SEINO_SUPER_EXPRESS = 'SEINO_SUPER_EXPRESS';

    /**
     * Floship.
     */
    public const FLOSHIP = 'FLOSHIP';

    /**
     * Metro Supply Chain.
     */
    public const METROSCG = 'METROSCG';

    /**
     * Sendparcel.
     */
    public const SENDPARCEL = 'SENDPARCEL';

    /**
     * P2p.
     */
    public const P2P = 'P2P';

    /**
     * Cn Express.
     */
    public const CN_EXPRESS = 'CN_EXPRESS';

    /**
     * Cirro Track.
     */
    public const CIRROTRACK = 'CIRROTRACK';

    /**
     * Land Logistics.
     */
    public const LAND_LOGISTICS = 'LAND_LOGISTICS';

    /**
     * Veho.
     */
    public const VEHO = 'VEHO';

    /**
     * Medline.
     */
    public const MEDLINE = 'MEDLINE';

    /**
     * Vdtrack.
     */
    public const VDTRACK = 'VDTRACK';

    /**
     * Sino Scm.
     */
    public const SINO_SCM = 'SINO_SCM';

    /**
     * 3pe Express.
     */
    public const ENUM_3PE_EXPRESS = '3PE_EXPRESS';

    /**
     * Swiftx.
     */
    public const SWIFTX = 'SWIFTX';

    /**
     * Sfyd Express.
     */
    public const SFYDEXPRESS = 'SFYDEXPRESS';

    /**
     * Toptrans.
     */
    public const TOPTRANS = 'TOPTRANS';
}
