<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The shipping information.
 */
class ShippingInformation implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $name;

    /**
     * @var string|null
     */
    private $method;

    /**
     * @var SimplePostalAddressCoarseGrained|null
     */
    private $address;

    /**
     * @var SimplePostalAddressCoarseGrained|null
     */
    private $secondaryShippingAddress;

    /**
     * Returns Name.
     * The recipient's name.
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * The recipient's name.
     *
     * @maps name
     */
    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns Method.
     * The shipping method that is associated with this order.
     */
    public function getMethod(): ?string
    {
        return $this->method;
    }

    /**
     * Sets Method.
     * The shipping method that is associated with this order.
     *
     * @maps method
     */
    public function setMethod(?string $method): void
    {
        $this->method = $method;
    }

    /**
     * Returns Address.
     * A simple postal address with coarse-grained fields. Do not use for an international address. Use for
     * backward compatibility only. Does not contain phone.
     */
    public function getAddress(): ?SimplePostalAddressCoarseGrained
    {
        return $this->address;
    }

    /**
     * Sets Address.
     * A simple postal address with coarse-grained fields. Do not use for an international address. Use for
     * backward compatibility only. Does not contain phone.
     *
     * @maps address
     */
    public function setAddress(?SimplePostalAddressCoarseGrained $address): void
    {
        $this->address = $address;
    }

    /**
     * Returns Secondary Shipping Address.
     * A simple postal address with coarse-grained fields. Do not use for an international address. Use for
     * backward compatibility only. Does not contain phone.
     */
    public function getSecondaryShippingAddress(): ?SimplePostalAddressCoarseGrained
    {
        return $this->secondaryShippingAddress;
    }

    /**
     * Sets Secondary Shipping Address.
     * A simple postal address with coarse-grained fields. Do not use for an international address. Use for
     * backward compatibility only. Does not contain phone.
     *
     * @maps secondary_shipping_address
     */
    public function setSecondaryShippingAddress(?SimplePostalAddressCoarseGrained $secondaryShippingAddress): void
    {
        $this->secondaryShippingAddress = $secondaryShippingAddress;
    }

    /**
     * Converts the ShippingInformation object to a human-readable string representation.
     *
     * @return string The string representation of the ShippingInformation object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'ShippingInformation',
            [
                'name' => $this->name,
                'method' => $this->method,
                'address' => $this->address,
                'secondaryShippingAddress' => $this->secondaryShippingAddress
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->name)) {
            $json['name']                       = $this->name;
        }
        if (isset($this->method)) {
            $json['method']                     = $this->method;
        }
        if (isset($this->address)) {
            $json['address']                    = $this->address;
        }
        if (isset($this->secondaryShippingAddress)) {
            $json['secondary_shipping_address'] = $this->secondaryShippingAddress;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
