<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The subscriber request information .
 */
class SubscriberRequest implements \JsonSerializable
{
    /**
     * @var Name|null
     */
    private $name;

    /**
     * @var PhoneWithType|null
     */
    private $phone;

    /**
     * @var ShippingDetails|null
     */
    private $shippingAddress;

    /**
     * @var SubscriptionPaymentSource|null
     */
    private $paymentSource;

    /**
     * Returns Name.
     * The name of the party.
     */
    public function getName(): ?Name
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * The name of the party.
     *
     * @maps name
     */
    public function setName(?Name $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns Phone.
     * The phone information.
     */
    public function getPhone(): ?PhoneWithType
    {
        return $this->phone;
    }

    /**
     * Sets Phone.
     * The phone information.
     *
     * @maps phone
     */
    public function setPhone(?PhoneWithType $phone): void
    {
        $this->phone = $phone;
    }

    /**
     * Returns Shipping Address.
     * The shipping details.
     */
    public function getShippingAddress(): ?ShippingDetails
    {
        return $this->shippingAddress;
    }

    /**
     * Sets Shipping Address.
     * The shipping details.
     *
     * @maps shipping_address
     */
    public function setShippingAddress(?ShippingDetails $shippingAddress): void
    {
        $this->shippingAddress = $shippingAddress;
    }

    /**
     * Returns Payment Source.
     * The payment source definition. To be eligible to create subscription using debit or credit card, you
     * will need to sign up here (https://www.paypal.com/bizsignup/entry/product/ppcp). Please note, its
     * available only for non-3DS cards and for merchants in US and AU regions.
     */
    public function getPaymentSource(): ?SubscriptionPaymentSource
    {
        return $this->paymentSource;
    }

    /**
     * Sets Payment Source.
     * The payment source definition. To be eligible to create subscription using debit or credit card, you
     * will need to sign up here (https://www.paypal.com/bizsignup/entry/product/ppcp). Please note, its
     * available only for non-3DS cards and for merchants in US and AU regions.
     *
     * @maps payment_source
     */
    public function setPaymentSource(?SubscriptionPaymentSource $paymentSource): void
    {
        $this->paymentSource = $paymentSource;
    }

    /**
     * Converts the SubscriberRequest object to a human-readable string representation.
     *
     * @return string The string representation of the SubscriberRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SubscriberRequest',
            [
                'name' => $this->name,
                'phone' => $this->phone,
                'shippingAddress' => $this->shippingAddress,
                'paymentSource' => $this->paymentSource
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->name)) {
            $json['name']             = $this->name;
        }
        if (isset($this->phone)) {
            $json['phone']            = $this->phone;
        }
        if (isset($this->shippingAddress)) {
            $json['shipping_address'] = $this->shippingAddress;
        }
        if (isset($this->paymentSource)) {
            $json['payment_source']   = $this->paymentSource;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
