<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The billing cycle details.
 */
class SubscriptionBillingCycle implements \JsonSerializable
{
    /**
     * @var SubscriptionPricingScheme|null
     */
    private $pricingScheme;

    /**
     * @var Frequency
     */
    private $frequency;

    /**
     * @var string
     */
    private $tenureType;

    /**
     * @var int
     */
    private $sequence;

    /**
     * @var int|null
     */
    private $totalCycles = 1;

    /**
     * @param Frequency $frequency
     * @param string $tenureType
     * @param int $sequence
     */
    public function __construct(Frequency $frequency, string $tenureType, int $sequence)
    {
        $this->frequency = $frequency;
        $this->tenureType = $tenureType;
        $this->sequence = $sequence;
    }

    /**
     * Returns Pricing Scheme.
     * The pricing scheme details.
     */
    public function getPricingScheme(): ?SubscriptionPricingScheme
    {
        return $this->pricingScheme;
    }

    /**
     * Sets Pricing Scheme.
     * The pricing scheme details.
     *
     * @maps pricing_scheme
     */
    public function setPricingScheme(?SubscriptionPricingScheme $pricingScheme): void
    {
        $this->pricingScheme = $pricingScheme;
    }

    /**
     * Returns Frequency.
     * The frequency of the billing cycle.
     */
    public function getFrequency(): Frequency
    {
        return $this->frequency;
    }

    /**
     * Sets Frequency.
     * The frequency of the billing cycle.
     *
     * @required
     * @maps frequency
     */
    public function setFrequency(Frequency $frequency): void
    {
        $this->frequency = $frequency;
    }

    /**
     * Returns Tenure Type.
     * The tenure type of the billing cycle. In case of a plan having trial cycle, only 2 trial cycles are
     * allowed per plan.
     */
    public function getTenureType(): string
    {
        return $this->tenureType;
    }

    /**
     * Sets Tenure Type.
     * The tenure type of the billing cycle. In case of a plan having trial cycle, only 2 trial cycles are
     * allowed per plan.
     *
     * @required
     * @maps tenure_type
     */
    public function setTenureType(string $tenureType): void
    {
        $this->tenureType = $tenureType;
    }

    /**
     * Returns Sequence.
     * The order in which this cycle is to run among other billing cycles. For example, a trial billing
     * cycle has a `sequence` of `1` while a regular billing cycle has a `sequence` of `2`, so that trial
     * cycle runs before the regular cycle.
     */
    public function getSequence(): int
    {
        return $this->sequence;
    }

    /**
     * Sets Sequence.
     * The order in which this cycle is to run among other billing cycles. For example, a trial billing
     * cycle has a `sequence` of `1` while a regular billing cycle has a `sequence` of `2`, so that trial
     * cycle runs before the regular cycle.
     *
     * @required
     * @maps sequence
     */
    public function setSequence(int $sequence): void
    {
        $this->sequence = $sequence;
    }

    /**
     * Returns Total Cycles.
     * The number of times this billing cycle gets executed. Trial billing cycles can only be executed a
     * finite number of times (value between 1 and 999 for total_cycles). Regular billing cycles can be
     * executed infinite times (value of 0 for total_cycles) or a finite number of times (value between 1
     * and 999 for total_cycles).
     */
    public function getTotalCycles(): ?int
    {
        return $this->totalCycles;
    }

    /**
     * Sets Total Cycles.
     * The number of times this billing cycle gets executed. Trial billing cycles can only be executed a
     * finite number of times (value between 1 and 999 for total_cycles). Regular billing cycles can be
     * executed infinite times (value of 0 for total_cycles) or a finite number of times (value between 1
     * and 999 for total_cycles).
     *
     * @maps total_cycles
     */
    public function setTotalCycles(?int $totalCycles): void
    {
        $this->totalCycles = $totalCycles;
    }

    /**
     * Converts the SubscriptionBillingCycle object to a human-readable string representation.
     *
     * @return string The string representation of the SubscriptionBillingCycle object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SubscriptionBillingCycle',
            [
                'pricingScheme' => $this->pricingScheme,
                'frequency' => $this->frequency,
                'tenureType' => $this->tenureType,
                'sequence' => $this->sequence,
                'totalCycles' => $this->totalCycles
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->pricingScheme)) {
            $json['pricing_scheme'] = $this->pricingScheme;
        }
        $json['frequency']          = $this->frequency;
        $json['tenure_type']        = $this->tenureType;
        $json['sequence']           = $this->sequence;
        if (isset($this->totalCycles)) {
            $json['total_cycles']   = $this->totalCycles;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
